/*
 * Decompiled with CFR 0.152.
 */
package levelup2.config;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import levelup2.util.JsonTransfer;
import levelup2.util.Library;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class LevelUpConfig {
    public static boolean resetClassOnDeath = true;
    public static boolean furnaceEjection = false;
    private static boolean resetJsonFiles = false;
    public static List<String> cropBlacklist;
    public static List<String> oreList;
    private static String[] ores;
    public static List<Integer> oreColors;
    private static int[] colors;
    public static List<String> netherOreList;
    private static String[] netherOres;
    public static List<Integer> netherOreColors;
    private static int[] netherColors;
    public static List<String> endOreList;
    private static String[] endOres;
    public static List<Integer> endOreColors;
    private static int[] endColors;
    private static Configuration cfg;
    private static Property[] serverProperties;
    public static int rareChance;
    public static int uncommonChance;
    public static int commonChance;
    public static int combinedChance;
    private static Property resetJson;
    private static Path configDir;
    private static Path jsonDir;
    public static Path lootDir;

    public static void init(File file) {
        configDir = file.getParentFile().toPath().resolve("levelup2");
        jsonDir = configDir.resolve("json");
        lootDir = jsonDir.resolve("loot_tables");
        cfg = new Configuration(file);
        serverProperties = new Property[]{cfg.get("general", "Reset class on death", resetClassOnDeath, "Does the player lose all levels on death?"), cfg.get("general", "Furnace ejects bonus items", furnaceEjection, "Does the furnace eject doubled items?")};
        cropBlacklist = Arrays.asList(cfg.getStringList("Crops for farming", "Blacklist", new String[]{""}, "Crops that won't be affected by farming growth skill, uses internal block name. No sync to client required."));
        oreList = Arrays.asList(cfg.get("general", "Surface Ores to double", ores, "Ores that double from mining efficiency").getStringList());
        oreColors = LevelUpConfig.getColorsFromProperty(cfg.get("general", "Surface Ore colors", colors, "Colors for the surface ore item"));
        netherOreList = Arrays.asList(cfg.get("general", "Nether Ores to double", netherOres, "Nether ores that double from mining efficiency").getStringList());
        netherOreColors = LevelUpConfig.getColorsFromProperty(cfg.get("general", "Nether Ore colors", netherColors, "Colors for the nether ore item"));
        endOreList = Arrays.asList(cfg.get("general", "End Ores to double", endOres, "End ores that double from mining efficiency").getStringList());
        endOreColors = LevelUpConfig.getColorsFromProperty(cfg.get("general", "End Ore colors", endColors, "Colors for the end ore item"));
        resetJson = cfg.get("debug", "Reset json files", resetJsonFiles, "Forces Level Up! to restore external json files to default");
        resetJsonFiles = resetJson.getBoolean();
        rareChance = cfg.getInt("Rare Digging Loot Chance", "digloot", rareChance, 0, 100, "Chances that a rare loot drop will appear");
        uncommonChance = cfg.getInt("Uncommon Digging Loot Chance", "digloot", uncommonChance, 0, 100, "Chances that an uncommon loot drop will appear");
        commonChance = cfg.getInt("Common Digging Loot Chance", "digloot", commonChance, 0, 100, "Chances that a common loot drop will appear");
        combinedChance = rareChance + uncommonChance + commonChance;
        if (cfg.hasChanged()) {
            cfg.save();
        }
        LevelUpConfig.useServerProperties();
        LevelUpConfig.transferLootTables();
        if (resetJsonFiles) {
            resetJson.set(false);
            cfg.save();
        }
    }

    public static Property[] getServerProperties() {
        return serverProperties;
    }

    public static void useServerProperties() {
        resetClassOnDeath = serverProperties[0].getBoolean();
        furnaceEjection = serverProperties[1].getBoolean();
    }

    private static List<Integer> getColorsFromProperty(Property prop) {
        int[] colors = prop.getIntList();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < colors.length; ++i) {
            list.add(colors[i]);
        }
        return list;
    }

    private static void transferLootTables() {
        HashSet<String> files = new HashSet<String>();
        files.add("fishing/fishing_loot");
        files.add("digging/common_dig");
        files.add("digging/uncommon_dig");
        files.add("digging/rare_dig");
        JsonTransfer.findResources(files).stream().forEach(r -> JsonTransfer.copyResource(r, configDir.resolve((String)r), resetJsonFiles));
        Library.registerLootTableLocations(files);
    }

    static {
        ores = new String[]{"oreCoal", "oreIron", "oreGold", "oreDiamond", "oreEmerald", "oreRedstone", "oreLapis", "oreCopper", "oreTin"};
        colors = new int[]{0x343434, 12360064, 16576075, 6155509, 1564002, 0xFF0000, 1653940, 16739601, 9416910};
        netherOres = new String[]{"oreQuartz"};
        netherColors = new int[]{0xE5DED5};
        endOres = new String[]{"null"};
        endColors = new int[]{0};
        rareChance = 1;
        uncommonChance = 15;
        commonChance = 85;
    }
}

