/*
 * Decompiled with CFR 0.152.
 */
package levelup2.gui;

import levelup2.api.IPlayerSkill;
import levelup2.gui.GuiSkills;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;

public class GuiSkillChoice
extends GuiScreen {
    private IPlayerSkill skill;
    private GuiSkills parent;
    private int skillLevel;
    private boolean canSpendLevels;
    private boolean canDowngrade;

    public GuiSkillChoice(IPlayerSkill skill, int skillLevel, GuiSkills parent) {
        this.skill = skill;
        this.parent = parent;
        this.skillLevel = skillLevel;
        this.canDowngrade = parent.player.getSkillLevel(skill.getSkillName()) < skillLevel;
        this.canSpendLevels = skill.getLevelCost(skillLevel) <= parent.availableLevels - parent.levelSpend && skill.getLevelCost(skillLevel) > -1 && parent.canUnlock(skill);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        GuiOptionButton button = new GuiOptionButton(0, this.field_146294_l / 2 - 65, this.field_146295_m / 2 + 35, 130, 20, I18n.func_135052_a((String)"levelup.skill.increase", (Object[])new Object[0]));
        button.field_146124_l = this.canSpendLevels;
        this.field_146292_n.add(button);
        button = new GuiOptionButton(1, this.field_146294_l / 2 - 65, this.field_146295_m / 2 + 60, 130, 20, I18n.func_135052_a((String)"levelup.skill.decrease", (Object[])new Object[0]));
        button.field_146124_l = this.canDowngrade;
        this.field_146292_n.add(button);
        this.field_146292_n.add(new GuiOptionButton(2, this.field_146294_l / 2 - 65, this.field_146295_m / 2 + 85, 130, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.drawCenteredString(I18n.func_135052_a((String)("skill." + this.skill.getSkillName() + ".name"), (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 100, -8355712);
        this.drawCenteredString(I18n.func_135052_a((String)(this.skill.getSkillName() + ".desc"), (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 82, -8355712);
        boolean secondLine = false;
        if (!I18n.func_135052_a((String)(this.skill.getSkillName() + ".desc.1"), (Object[])new Object[0]).equals(this.skill.getSkillName() + ".desc.1")) {
            secondLine = true;
            this.drawCenteredString(I18n.func_135052_a((String)(this.skill.getSkillName() + ".desc.1"), (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 64, -8355712);
        }
        if (this.skill.getLevelCost(this.skillLevel) > -1) {
            this.drawCenteredString(I18n.func_135052_a((String)"levelup.cost", (Object[])new Object[]{this.skill.getLevelCost(this.skillLevel)}), this.field_146294_l / 2, this.field_146295_m / 2 - (secondLine ? 46 : 64), -8355712);
        }
        this.drawCenteredString(I18n.func_135052_a((String)"levelup.levels.track", (Object[])new Object[]{this.skillLevel, this.parent.player.getSkillLevel(this.skill.getSkillName())}), this.field_146294_l / 2, this.field_146295_m / 2 + 15, -8355712);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.changeSkillLevel(1);
            this.parent.levelSpend += this.skill.getLevelCost(this.skillLevel);
        } else if (button.field_146127_k == 1) {
            this.changeSkillLevel(-1);
            this.parent.levelSpend -= this.skill.getLevelCost(this.skillLevel - 1);
        }
        this.field_146297_k.func_147108_a((GuiScreen)this.parent);
    }

    private void drawCenteredString(String str, int posX, int posY, int color) {
        int centerWidth = this.field_146289_q.func_78256_a(str) / 2;
        this.field_146289_q.func_78276_b(str, posX - centerWidth, posY, color);
    }

    private void changeSkillLevel(int add) {
        int orig = this.parent.skills.get(this.skill.getSkillName());
        this.parent.skills.put(this.skill.getSkillName(), orig + add);
    }
}

