/*
 * Decompiled with CFR 0.152.
 */
package levelup2.player;

import java.util.HashMap;
import java.util.Map;
import levelup2.api.IPlayerSkill;
import levelup2.player.IPlayerClass;
import levelup2.skills.SkillRegistry;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class PlayerExtension
implements IPlayerClass {
    private Map<String, Integer> skillMap = new HashMap<String, Integer>();

    public PlayerExtension() {
        for (IPlayerSkill skill : SkillRegistry.getSkillRegistry()) {
            this.skillMap.put(skill.getSkillName(), 0);
        }
    }

    @Override
    public NBTTagCompound saveNBTData(NBTTagCompound tag) {
        NBTTagCompound combat = new NBTTagCompound();
        NBTTagCompound crafting = new NBTTagCompound();
        NBTTagCompound mining = new NBTTagCompound();
        block4: for (String skillName : this.skillMap.keySet()) {
            IPlayerSkill skill = this.getSkillFromName(skillName);
            byte skillType = skill.getSkillType();
            switch (skillType) {
                case 1: {
                    crafting.func_74768_a(skill.getSkillName(), this.skillMap.get(skillName).intValue());
                    continue block4;
                }
                case 2: {
                    combat.func_74768_a(skill.getSkillName(), this.skillMap.get(skillName).intValue());
                    continue block4;
                }
            }
            mining.func_74768_a(skill.getSkillName(), this.skillMap.get(skillName).intValue());
        }
        tag.func_74782_a("Combat", (NBTBase)combat);
        tag.func_74782_a("Crafting", (NBTBase)crafting);
        tag.func_74782_a("Mining", (NBTBase)mining);
        return tag;
    }

    @Override
    public void loadNBTData(NBTTagCompound tag) {
        for (String skill : this.skillMap.keySet()) {
            IPlayerSkill playerSkill = this.getSkillFromName(skill);
            byte skillType = playerSkill.getSkillType();
            String skillName = skillType == 0 ? "Mining" : (skillType == 1 ? "Crafting" : "Combat");
            NBTTagCompound skillTag = tag.func_74775_l(skillName);
            this.setSkillLevel(skill, skillTag.func_74762_e(playerSkill.getSkillName()));
        }
    }

    @Override
    public IPlayerSkill getSkillFromName(String name) {
        return SkillRegistry.getSkillFromName(name);
    }

    @Override
    public void addToSkill(String name, int increase) {
        this.setSkillLevel(name, this.skillMap.get(name) + increase);
    }

    @Override
    public int getSkillLevel(String name) {
        return this.skillMap.get(name);
    }

    @Override
    public void setSkillLevel(String name, int level) {
        this.skillMap.put(name, level);
    }

    @Override
    public void setPlayerData(String[] names, int[] data) {
        for (int i = 0; i < names.length && i < data.length; ++i) {
            this.setSkillLevel(names[i], data[i]);
        }
    }

    @Override
    public boolean hasClass() {
        return this.getSkillLevel("levelup:mining_bonus") > 0 || this.getSkillLevel("levelup:craft_bonus") > 0 || this.getSkillLevel("levelup:combat_bonus") > 0;
    }

    @Override
    public byte getSpecialization() {
        if (this.getSkillLevel("levelup:mining_bonus") > 0) {
            return 0;
        }
        if (this.getSkillLevel("levelup:craft_bonus") > 0) {
            return 1;
        }
        if (this.getSkillLevel("levelup:combat_bonus") > 0) {
            return 2;
        }
        return -1;
    }

    @Override
    public void setSpecialization(byte spec) {
        if (spec > -1) {
            switch (spec) {
                case 0: {
                    this.setSkillLevel("levelup:mining_bonus", 1);
                    break;
                }
                case 1: {
                    this.setSkillLevel("levelup:craft_bonus", 1);
                    break;
                }
                case 2: {
                    this.setSkillLevel("levelup:combat_bonus", 1);
                }
            }
        }
    }

    @Override
    public Map<String, Integer> getSkills() {
        return this.skillMap;
    }
}

