/*
 * Decompiled with CFR 0.152.
 */
package levelup2.skills.combat;

import levelup2.skills.BaseSkill;
import levelup2.skills.SkillRegistry;
import levelup2.util.Library;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ArrowSpeedBonus
extends BaseSkill {
    private int[] levels = new int[]{11, 17, 29, 37, 41};

    @Override
    public String getSkillName() {
        return "levelup:arrowspeed";
    }

    @Override
    public int getLevelCost(int currentLevel) {
        if (currentLevel >= 0 && currentLevel < this.getMaxLevel()) {
            return Library.fiveLevels[currentLevel];
        }
        return -1;
    }

    @Override
    public ItemStack getRepresentativeStack() {
        return new ItemStack(Items.field_151032_g);
    }

    @Override
    public String[] getPrerequisites() {
        return new String[]{"levelup:bowdraw"};
    }

    @Override
    public int getSkillRow() {
        return 1;
    }

    @Override
    public int getSkillColumn() {
        return 2;
    }

    @Override
    public byte getSkillType() {
        return 2;
    }

    @Override
    public boolean hasSubscription() {
        return true;
    }

    @Override
    public int getMaxLevel() {
        return 5;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onArrowLoose(EntityJoinWorldEvent evt) {
        if (evt.getEntity() instanceof EntityArrow) {
            int archer;
            EntityArrow arrow = (EntityArrow)evt.getEntity();
            if (arrow.field_70250_c instanceof EntityPlayer && (archer = SkillRegistry.getSkillLevel((EntityPlayer)arrow.field_70250_c, this.getSkillName())) > 0) {
                arrow.field_70159_w *= (double)(1.0f + (float)archer / 10.0f);
                arrow.field_70181_x *= (double)(1.0f + (float)archer / 10.0f);
                arrow.field_70179_y *= (double)(1.0f + (float)archer / 10.0f);
            }
        }
    }
}

