/*
 * Decompiled with CFR 0.152.
 */
package levelup2.skills.combat;

import levelup2.skills.BaseSkill;
import levelup2.skills.SkillRegistry;
import levelup2.util.Library;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class NaturalArmorBonus
extends BaseSkill {
    @Override
    public String getSkillName() {
        return "levelup:naturalarmor";
    }

    @Override
    public int getSkillRow() {
        return 1;
    }

    @Override
    public int getSkillColumn() {
        return 4;
    }

    @Override
    public byte getSkillType() {
        return 2;
    }

    @Override
    public boolean hasSubscription() {
        return true;
    }

    @Override
    public String[] getPrerequisites() {
        return new String[]{"levelup:shieldblock"};
    }

    @Override
    public int getMaxLevel() {
        return 10;
    }

    @Override
    public int getLevelCost(int currentLevel) {
        if (currentLevel >= 0 && currentLevel < this.getMaxLevel()) {
            return Library.highTenLevels[currentLevel];
        }
        return -1;
    }

    @Override
    public ItemStack getRepresentativeStack() {
        return new ItemStack((Item)Items.field_151030_Z);
    }

    @SubscribeEvent
    public void onDamageTaken(LivingHurtEvent evt) {
        EntityPlayer player;
        int skill;
        if (evt.getEntityLiving() instanceof EntityPlayer && (skill = SkillRegistry.getSkillLevel(player = (EntityPlayer)evt.getEntityLiving(), this.getSkillName())) > 0 && !evt.getSource().func_76363_c()) {
            float amount = evt.getAmount() * (1.0f - (float)skill / 20.0f);
            evt.setAmount(amount);
        }
    }
}

