/*
 * Decompiled with CFR 0.152.
 */
package levelup2.skills.combat;

import levelup2.skills.BaseSkill;
import levelup2.skills.SkillRegistry;
import levelup2.skills.combat.StealthLib;
import levelup2.util.Library;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class StealthDamage
extends BaseSkill {
    @Override
    public String getSkillName() {
        return "levelup:stealthdamage";
    }

    @Override
    public byte getSkillType() {
        return 2;
    }

    @Override
    public int getSkillColumn() {
        return 3;
    }

    @Override
    public int getSkillRow() {
        return 1;
    }

    @Override
    public String[] getPrerequisites() {
        return new String[]{"levelup:stealth"};
    }

    @Override
    public int getMaxLevel() {
        return 5;
    }

    @Override
    public int getLevelCost(int currentLevel) {
        if (currentLevel >= 0 && currentLevel < this.getMaxLevel()) {
            return Library.fiveLevels[currentLevel];
        }
        return -1;
    }

    @Override
    public ItemStack getRepresentativeStack() {
        return new ItemStack(Items.field_151170_bI);
    }

    @Override
    public boolean hasSubscription() {
        return true;
    }

    @SubscribeEvent
    public void onDamage(LivingHurtEvent evt) {
        EntityPlayer player;
        int level;
        DamageSource src = evt.getSource();
        float dmg = evt.getAmount();
        if (src.func_76346_g() instanceof EntityPlayer && (level = SkillRegistry.getSkillLevel(player = (EntityPlayer)src.func_76346_g(), this.getSkillName())) > 0) {
            if (src instanceof EntityDamageSourceIndirect) {
                if (StealthLib.getDistanceFrom(evt.getEntityLiving(), (EntityLivingBase)player) < 256.0f && player.func_70093_af() && !StealthLib.canSeePlayer(evt.getEntityLiving()) && !StealthLib.entityIsFacing(evt.getEntityLiving(), (EntityLivingBase)player)) {
                    dmg *= 1.0f + 0.15f * (float)level;
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("sneak.attack", new Object[]{1.0 + 0.15 * (double)level}), true);
                }
            } else if (player.func_70093_af() && !StealthLib.canSeePlayer(evt.getEntityLiving()) && !StealthLib.entityIsFacing(evt.getEntityLiving(), (EntityLivingBase)player)) {
                dmg *= 1.0f + 0.3f * (float)level;
                player.func_146105_b((ITextComponent)new TextComponentTranslation("sneak.attack", new Object[]{1.0 + 0.3 * (double)level}), true);
            }
        }
        evt.setAmount(dmg);
    }
}

