/*
 * Decompiled with CFR 0.152.
 */
package levelup2.skills.combat;

import levelup2.skills.BaseSkill;
import levelup2.skills.SkillRegistry;
import levelup2.util.Library;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class StealthSpeed
extends BaseSkill {
    @Override
    public String getSkillName() {
        return "levelup:stealthspeed";
    }

    @Override
    public int getSkillRow() {
        return 2;
    }

    @Override
    public int getSkillColumn() {
        return 3;
    }

    @Override
    public byte getSkillType() {
        return 2;
    }

    @Override
    public boolean hasSubscription() {
        return true;
    }

    @Override
    public String[] getPrerequisites() {
        return new String[]{"levelup:stealth", "levelup:fallprotect"};
    }

    @Override
    public int getMaxLevel() {
        return 10;
    }

    @Override
    public int getLevelCost(int currentLevel) {
        if (currentLevel >= 0 && currentLevel < this.getMaxLevel()) {
            return Library.tenLevels[currentLevel];
        }
        return -1;
    }

    @Override
    public ItemStack getRepresentativeStack() {
        return new ItemStack((Item)Items.field_151021_T);
    }

    @SubscribeEvent
    public void onPlayerSneak(TickEvent.PlayerTickEvent evt) {
        int skill;
        if (evt.phase == TickEvent.Phase.START && (skill = SkillRegistry.getSkillLevel(evt.player, this.getSkillName())) > 0) {
            IAttributeInstance attrib = evt.player.func_110148_a(SharedMonsterAttributes.field_111263_d);
            AttributeModifier mod = new AttributeModifier(Library.sneakID, "SneakingSkillSpeed", (double)((float)skill / 10.0f), 2);
            if (evt.player.func_70093_af()) {
                if (attrib.func_111127_a(Library.sneakID) == null) {
                    attrib.func_111121_a(mod);
                }
            } else if (attrib.func_111127_a(Library.sneakID) != null) {
                attrib.func_111124_b(mod);
            }
        }
    }
}

