/*
 * Decompiled with CFR 0.152.
 */
package levelup2.skills.combat;

import levelup2.skills.BaseSkill;
import levelup2.skills.SkillRegistry;
import levelup2.util.Library;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SwordDamageBonus
extends BaseSkill {
    @Override
    public String getSkillName() {
        return "levelup:sworddamage";
    }

    @Override
    public int getSkillRow() {
        return 1;
    }

    @Override
    public int getSkillColumn() {
        return 1;
    }

    @Override
    public byte getSkillType() {
        return 2;
    }

    @Override
    public boolean hasSubscription() {
        return true;
    }

    @Override
    public String[] getPrerequisites() {
        return new String[]{"levelup:swordcrit"};
    }

    @Override
    public int getMaxLevel() {
        return 10;
    }

    @Override
    public int getLevelCost(int currentLevel) {
        if (currentLevel >= 0 && currentLevel < this.getMaxLevel()) {
            return Library.highTenLevels[currentLevel];
        }
        return -1;
    }

    @Override
    public ItemStack getRepresentativeStack() {
        return new ItemStack(Items.field_151010_B);
    }

    @SubscribeEvent
    public void onHurting(LivingHurtEvent evt) {
        EntityPlayer player;
        int skill;
        DamageSource source = evt.getSource();
        float amount = evt.getAmount();
        if (source.func_76346_g() instanceof EntityPlayer && (skill = SkillRegistry.getSkillLevel(player = (EntityPlayer)source.func_76346_g(), this.getSkillName())) > 0 && !(source instanceof EntityDamageSourceIndirect) && !player.func_184614_ca().func_190926_b()) {
            evt.setAmount(amount *= 1.0f + (float)skill / 20.0f);
        }
    }
}

