/*
 * Decompiled with CFR 0.152.
 */
package levelup2.skills.crafting;

import java.util.Random;
import levelup2.skills.BaseSkill;
import levelup2.skills.SkillRegistry;
import levelup2.util.Library;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockStem;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FoodHarvestBonus
extends BaseSkill {
    @Override
    public String getSkillName() {
        return "levelup:harvestbonus";
    }

    @Override
    public int getSkillRow() {
        return 1;
    }

    @Override
    public int getSkillColumn() {
        return 2;
    }

    @Override
    public byte getSkillType() {
        return 1;
    }

    @Override
    public int getLevelCost(int currentLevel) {
        if (currentLevel >= 0 && currentLevel < this.getMaxLevel()) {
            return Library.tenLevels[currentLevel];
        }
        return -1;
    }

    @Override
    public int getMaxLevel() {
        return 10;
    }

    @Override
    public String[] getPrerequisites() {
        return new String[]{"levelup:cropgrowth"};
    }

    @Override
    public ItemStack getRepresentativeStack() {
        return new ItemStack(Items.field_151015_O);
    }

    @Override
    public boolean hasSubscription() {
        return true;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockBroken(BlockEvent.BreakEvent evt) {
        if (!evt.getWorld().field_72995_K && evt.getPlayer() != null) {
            if (evt.getState().func_177230_c() instanceof BlockCrops || evt.getState().func_177230_c() instanceof BlockStem) {
                if (!((IGrowable)evt.getState().func_177230_c()).func_176473_a(evt.getWorld(), evt.getPos(), evt.getState(), false)) {
                    this.doCropDrops(evt);
                }
            } else if (evt.getState().func_177230_c() instanceof BlockMelon) {
                this.doCropDrops(evt);
            }
        }
    }

    private void doCropDrops(BlockEvent.BreakEvent evt) {
        Random rand = evt.getPlayer().func_70681_au();
        int skill = SkillRegistry.getSkillLevel(evt.getPlayer(), this.getSkillName());
        if (skill > 0 && rand.nextInt(10) < skill) {
            Item item = evt.getState().func_177230_c().func_180660_a(evt.getState(), rand, 0);
            if (item == Items.field_190931_a || item == null) {
                if (evt.getState().func_177230_c() == Blocks.field_150393_bb) {
                    item = Items.field_151080_bb;
                } else if (evt.getState().func_177230_c() == Blocks.field_150394_bc) {
                    item = Items.field_151081_bc;
                }
            }
            if (item != Items.field_190931_a && item != null) {
                evt.getWorld().func_72838_d((Entity)new EntityItem(evt.getWorld(), (double)evt.getPos().func_177958_n(), (double)evt.getPos().func_177956_o(), (double)evt.getPos().func_177952_p(), new ItemStack(item, Math.max(1, evt.getState().func_177230_c().quantityDropped(evt.getState(), 0, rand)), evt.getState().func_177230_c().func_180651_a(evt.getState()))));
            }
        }
    }
}

