/*
 * Decompiled with CFR 0.152.
 */
package levelup2.skills.crafting;

import java.util.ArrayList;
import java.util.Random;
import levelup2.skills.BaseSkill;
import levelup2.skills.SkillRegistry;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class XPBonusCrafting
extends BaseSkill {
    private Random rand = new Random();

    @Override
    public boolean hasSubscription() {
        return true;
    }

    @Override
    public String getSkillName() {
        return "levelup:craft_bonus";
    }

    @Override
    public int getLevelCost(int currentLevel) {
        return -1;
    }

    @Override
    public byte getSkillType() {
        return 1;
    }

    @Override
    public String[] getPrerequisites() {
        return new String[0];
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent evt) {
        int craftingChances;
        if (SkillRegistry.getSkillLevel(evt.player, this.getSkillName()) > 0 && this.isNotOneItemCrafting(evt.craftMatrix) && (craftingChances = this.getCraftingItems(evt.craftMatrix)) > 0) {
            int experienceGain = 0;
            for (int i = 0; i < this.getCraftingItems(evt.craftMatrix); ++i) {
                if (!(this.rand.nextFloat() < 0.55f)) continue;
                ++experienceGain;
            }
            if (experienceGain > 0) {
                SkillRegistry.addExperience(evt.player, experienceGain);
            }
        }
    }

    private boolean isNotOneItemCrafting(IInventory inv) {
        boolean notSame = false;
        ItemStack firstStack = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            if (firstStack.func_190926_b()) {
                firstStack = inv.func_70301_a(i).func_77946_l();
                continue;
            }
            if (firstStack.func_77969_a(inv.func_70301_a(i))) continue;
            notSame = true;
        }
        return notSame;
    }

    private int getCraftingItems(IInventory inv) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            ItemStack stack = inv.func_70301_a(i).func_77946_l();
            stack.func_190920_e(1);
            if (items.isEmpty()) {
                items.add(stack);
                continue;
            }
            if (SkillRegistry.listContains(stack, items)) continue;
            items.add(stack);
        }
        return items.size();
    }

    @Override
    public int getSkillRow() {
        return 0;
    }

    @Override
    public int getSkillColumn() {
        return 0;
    }

    @Override
    public ItemStack getRepresentativeStack() {
        return new ItemStack(Blocks.field_150462_ai);
    }

    @Override
    public boolean isMaxLevel(int level) {
        return true;
    }

    @Override
    public int getMaxLevel() {
        return 1;
    }
}

