/*
 * Decompiled with CFR 0.152.
 */
package levelup2.skills.mining;

import java.util.Random;
import levelup2.config.LevelUpConfig;
import levelup2.skills.BaseSkill;
import levelup2.skills.SkillRegistry;
import levelup2.util.Library;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DiggingTreasureBonus
extends BaseSkill {
    @Override
    public String getSkillName() {
        return "levelup:treasurehunting";
    }

    @Override
    public int getSkillRow() {
        return 1;
    }

    @Override
    public int getSkillColumn() {
        return 4;
    }

    @Override
    public boolean hasSubscription() {
        return true;
    }

    @Override
    public int getLevelCost(int currentLevel) {
        if (currentLevel >= 0 && currentLevel < this.getMaxLevel()) {
            return Library.fiveLevels[currentLevel];
        }
        return -1;
    }

    @Override
    public byte getSkillType() {
        return 0;
    }

    @Override
    public String[] getPrerequisites() {
        return new String[]{"levelup:flintloot"};
    }

    @Override
    public int getMaxLevel() {
        return 5;
    }

    @Override
    public ItemStack getRepresentativeStack() {
        return new ItemStack(Items.field_151011_C);
    }

    @SubscribeEvent
    public void dirtLooting(BlockEvent.HarvestDropsEvent evt) {
        if (evt.getHarvester() != null && !evt.getWorld().field_72995_K) {
            IBlockState state = evt.getState();
            Random rand = evt.getHarvester().func_70681_au();
            int skill = SkillRegistry.getSkillLevel(evt.getHarvester(), this.getSkillName());
            if (skill > 0 && !evt.isSilkTouching() && state.func_185904_a() == Material.field_151578_c && rand.nextFloat() <= (float)skill / 20.0f) {
                ItemStack loot = this.getDigLoot(evt.getHarvester());
                System.out.println("ItemStack: " + loot.toString());
                if (!loot.func_190926_b()) {
                    Library.removeFromList(evt.getDrops(), new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_180651_a(state)));
                    evt.getDrops().add(loot.func_77946_l());
                }
            }
        }
    }

    private ItemStack getDigLoot(EntityPlayer player) {
        if (!player.func_130014_f_().field_72995_K) {
            LootContext.Builder build = new LootContext.Builder((WorldServer)player.func_130014_f_()).func_186470_a(player);
            build.func_186469_a((float)EnchantmentHelper.func_185284_a((Enchantment)Enchantment.func_180305_b((String)"fortune"), (EntityLivingBase)player) + player.func_184817_da());
            ResourceLocation location = this.getTableFromWeightedPool(player.func_70681_au());
            if (location != null) {
                return (ItemStack)Library.getLootManager().getLootTableFromLocation(location).func_186462_a(player.func_70681_au(), build.func_186471_a()).get(0);
            }
        }
        return ItemStack.field_190927_a;
    }

    private ResourceLocation getTableFromWeightedPool(Random rand) {
        if (LevelUpConfig.combinedChance == 0) {
            return null;
        }
        int RNG = rand.nextInt(LevelUpConfig.combinedChance);
        if (LevelUpConfig.rareChance > 0 && RNG <= LevelUpConfig.rareChance) {
            return new ResourceLocation("levelup", "digging/rare_dig");
        }
        if (LevelUpConfig.uncommonChance > 0 && RNG <= LevelUpConfig.rareChance + LevelUpConfig.uncommonChance) {
            return new ResourceLocation("levelup", "digging/uncommon_dig");
        }
        return new ResourceLocation("levelup", "digging/common_dig");
    }
}

