/*
 * Decompiled with CFR 0.152.
 */
package levelup2.skills.mining;

import java.util.Random;
import levelup2.skills.BaseSkill;
import levelup2.skills.SkillRegistry;
import levelup2.util.Library;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FlintLootBonus
extends BaseSkill {
    @Override
    public String getSkillName() {
        return "levelup:flintloot";
    }

    @Override
    public int getSkillColumn() {
        return 4;
    }

    @Override
    public int getSkillRow() {
        return 0;
    }

    @Override
    public boolean hasSubscription() {
        return true;
    }

    @Override
    public int getLevelCost(int currentLevel) {
        if (currentLevel >= 0 && currentLevel < this.getMaxLevel()) {
            return Library.tenLevels[currentLevel];
        }
        return -1;
    }

    @Override
    public byte getSkillType() {
        return 0;
    }

    @Override
    public String[] getPrerequisites() {
        return new String[0];
    }

    @Override
    public int getMaxLevel() {
        return 10;
    }

    @Override
    public ItemStack getRepresentativeStack() {
        return new ItemStack(Blocks.field_150351_n);
    }

    @SubscribeEvent
    public void gravelLooting(BlockEvent.HarvestDropsEvent evt) {
        if (evt.getHarvester() != null && !evt.getWorld().field_72995_K) {
            IBlockState state = evt.getState();
            Random rand = evt.getHarvester().func_70681_au();
            int skill = SkillRegistry.getSkillLevel(evt.getHarvester(), this.getSkillName());
            if (!evt.isSilkTouching() && skill > 0 && state.func_177230_c() instanceof BlockGravel && rand.nextInt(10) < skill) {
                Library.removeFromList(evt.getDrops(), new ItemStack(state.func_177230_c()));
                evt.getDrops().add(new ItemStack(Items.field_151145_ak));
            }
        }
    }
}

