/*
 * Decompiled with CFR 0.152.
 */
package levelup2.skills.mining;

import levelup2.skills.BaseSkill;
import levelup2.skills.SkillRegistry;
import levelup2.util.Library;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SprintSpeedBonus
extends BaseSkill {
    @Override
    public String getSkillName() {
        return "levelup:sprintspeed";
    }

    @Override
    public int getSkillRow() {
        return 0;
    }

    @Override
    public int getSkillColumn() {
        return 3;
    }

    @Override
    public boolean hasSubscription() {
        return true;
    }

    @Override
    public int getLevelCost(int currentLevel) {
        if (currentLevel >= 0 && currentLevel < this.getMaxLevel()) {
            return Library.tenLevels[currentLevel];
        }
        return -1;
    }

    @Override
    public byte getSkillType() {
        return 0;
    }

    @Override
    public String[] getPrerequisites() {
        return new String[0];
    }

    @Override
    public int getMaxLevel() {
        return 10;
    }

    @Override
    public ItemStack getRepresentativeStack() {
        return new ItemStack(Items.field_179556_br);
    }

    @SubscribeEvent
    public void onPlayerSprint(TickEvent.PlayerTickEvent evt) {
        int skill;
        if (evt.phase == TickEvent.Phase.START && (skill = SkillRegistry.getSkillLevel(evt.player, this.getSkillName())) > 0) {
            IAttributeInstance attrib = evt.player.func_110148_a(SharedMonsterAttributes.field_111263_d);
            AttributeModifier mod = new AttributeModifier(Library.speedID, "SprintingSkillSpeed", (double)((float)skill / 20.0f), 2);
            if (evt.player.func_70051_ag()) {
                if (attrib.func_111127_a(Library.speedID) == null) {
                    attrib.func_111121_a(mod);
                }
            } else if (attrib.func_111127_a(Library.speedID) != null) {
                attrib.func_111124_b(mod);
            }
        }
    }
}

