/*
 * Decompiled with CFR 0.152.
 */
package levelup2.skills.mining;

import java.util.Random;
import levelup2.skills.BaseSkill;
import levelup2.skills.SkillRegistry;
import levelup2.util.Library;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class StoneMiningBonus
extends BaseSkill {
    @Override
    public String getSkillName() {
        return "levelup:prospecting";
    }

    @Override
    public int getSkillRow() {
        return 1;
    }

    @Override
    public int getSkillColumn() {
        return 1;
    }

    @Override
    public boolean hasSubscription() {
        return true;
    }

    @Override
    public int getLevelCost(int currentLevel) {
        if (currentLevel >= 0 && currentLevel < this.getMaxLevel()) {
            return Library.fiveLevels[currentLevel];
        }
        return -1;
    }

    @Override
    public byte getSkillType() {
        return 0;
    }

    @Override
    public String[] getPrerequisites() {
        return new String[]{"levelup:stonecutting"};
    }

    @Override
    public int getMaxLevel() {
        return 5;
    }

    @Override
    public ItemStack getRepresentativeStack() {
        return new ItemStack(Blocks.field_150352_o);
    }

    @SubscribeEvent
    public void onHarvest(BlockEvent.HarvestDropsEvent evt) {
        if (evt.getHarvester() != null && !evt.getWorld().field_72995_K) {
            int skill = SkillRegistry.getSkillLevel(evt.getHarvester(), this.getSkillName());
            IBlockState state = evt.getState();
            Random rand = evt.getHarvester().func_70681_au();
            if (!Library.getOreList().isEmpty() && Library.getOreList().contains(state.func_177230_c()) && rand.nextDouble() <= (double)skill / 20.0) {
                int quantity;
                Item item;
                boolean foundBlock = false;
                for (ItemStack stack : evt.getDrops()) {
                    if (stack.func_190926_b() || state.func_177230_c() != Block.func_149634_a((Item)stack.func_77973_b())) continue;
                    Library.removeFromList(evt.getDrops(), stack);
                    evt.getDrops().add(this.getReplacementStack(stack));
                    foundBlock = true;
                    break;
                }
                if (!foundBlock && (item = state.func_177230_c().func_180660_a(state, rand, evt.getFortuneLevel())) != null && (quantity = state.func_177230_c().quantityDropped(state, evt.getFortuneLevel(), rand)) > 0) {
                    evt.getDrops().add(new ItemStack(item, quantity, state.func_177230_c().func_180651_a(state)));
                }
            }
        }
    }

    private ItemStack getReplacementStack(ItemStack stack) {
        return Library.getChunkFromName(Library.getOreNameForBlock(stack));
    }
}

