/*
 * Decompiled with CFR 0.152.
 */
package levelup2.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class FortuneEnchantBonus
extends LootFunction {
    private final RandomValueRange count;
    private final int limit;

    public FortuneEnchantBonus(LootCondition[] conditions, RandomValueRange count, int limit) {
        super(conditions);
        this.count = count;
        this.limit = limit;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        Entity entity = context.func_186492_c();
        if (entity instanceof EntityLivingBase) {
            int i = EnchantmentHelper.func_185284_a((Enchantment)Enchantment.func_180305_b((String)"fortune"), (EntityLivingBase)((EntityLivingBase)entity));
            if (i == 0) {
                return stack;
            }
            float f = (float)i * this.count.func_186507_b(rand);
            int size = stack.func_190916_E() + Math.round(f);
            if (this.limit != 0 && size > this.limit) {
                stack.func_190920_e(this.limit);
            } else {
                stack.func_190920_e(size);
            }
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<FortuneEnchantBonus> {
        protected Serializer() {
            super(new ResourceLocation("fortune_enchant"), FortuneEnchantBonus.class);
        }

        public void serialize(JsonObject object, FortuneEnchantBonus functionClazz, JsonSerializationContext serializationContext) {
            object.add("count", serializationContext.serialize((Object)functionClazz.count));
            if (functionClazz.limit > 0) {
                object.add("limit", serializationContext.serialize((Object)functionClazz.limit));
            }
        }

        public FortuneEnchantBonus deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            int i = JsonUtils.func_151208_a((JsonObject)object, (String)"limit", (int)0);
            return new FortuneEnchantBonus(conditionsIn, (RandomValueRange)JsonUtils.func_188174_a((JsonObject)object, (String)"count", (JsonDeserializationContext)deserializationContext, RandomValueRange.class), i);
        }
    }
}

