/*
 * Decompiled with CFR 0.152.
 */
package assets.levelup;

import assets.levelup.BowEventHandler;
import assets.levelup.ClassBonus;
import assets.levelup.FightEventHandler;
import assets.levelup.ItemRespecBook;
import assets.levelup.PlayerEventHandler;
import assets.levelup.PlayerExtendedProperties;
import assets.levelup.SkillPacketHandler;
import assets.levelup.SkillProxy;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod(modid="levelup", useMetadata=true, guiFactory="assets.levelup.ConfigLevelUp")
public class LevelUp {
    @Mod.Instance(value="levelup")
    public static LevelUp instance;
    @SidedProxy(clientSide="assets.levelup.SkillClientProxy", serverSide="assets.levelup.SkillProxy")
    public static SkillProxy proxy;
    private static Item xpTalisman;
    private static Map<Item, Integer> towItems;
    private static Item[] ingrTier1;
    private static Item[] ingrTier2;
    private static Item[] ingrTier3;
    private static Item[] ingrTier4;
    private static Configuration config;
    public static boolean allowHUD;
    public static boolean renderTopLeft;
    public static boolean renderExpBar;
    public static FMLEventChannel initChannel;
    public static FMLEventChannel skillChannel;
    public static FMLEventChannel classChannel;

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        PlayerEventHandler handler = new PlayerEventHandler();
        FMLCommonHandler.instance().bus().register((Object)handler);
        MinecraftForge.EVENT_BUS.register((Object)handler);
        MinecraftForge.EVENT_BUS.register((Object)new BowEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FightEventHandler());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        SkillPacketHandler sk = new SkillPacketHandler();
        initChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(SkillPacketHandler.CHAN[0]);
        initChannel.register((Object)sk);
        classChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(SkillPacketHandler.CHAN[1]);
        classChannel.register((Object)sk);
        skillChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(SkillPacketHandler.CHAN[2]);
        skillChannel.register((Object)sk);
        proxy.registerGui();
    }

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        allowHUD = config.get("HUD", "allow HUD", true).getBoolean(true);
        renderTopLeft = config.get("HUD", "render HUD on Top Left", true).getBoolean(true);
        renderExpBar = config.get("HUD", "render HUD on Exp Bar", true).getBoolean(true);
        ItemRespecBook.resClass = config.get("Cheats", "unlearning Book Reset Class", false).getBoolean(false);
        int option = config.get("Cheats", "Max points per skill", 50).getInt(50);
        ClassBonus.maxSkillPoints = option > 0 ? option : 50;
        option = config.get("Cheats", "Xp gain per level", 3).getInt(3);
        PlayerEventHandler.xpPerLevel = option >= 0 ? option : 3;
        PlayerEventHandler.oldSpeedDigging = config.get("Cheats", "Use old speed for dirt and gravel digging", true).getBoolean(true);
        PlayerEventHandler.oldSpeedRedstone = config.get("Cheats", "Use old speed for redstone breaking", true).getBoolean(true);
        PlayerEventHandler.resetSkillOnDeath = config.get("Cheats", "Reset player skill points on death", false).getBoolean(false);
        PlayerEventHandler.resetClassOnDeath = config.get("Cheats", "Reset player class on death", false).getBoolean(false);
        if (config.hasChanged()) {
            config.save();
        }
        ingrTier1 = new Item[]{Items.field_151055_y, Items.field_151116_aA, Item.func_150898_a((Block)Blocks.field_150348_b)};
        ingrTier2 = new Item[]{Items.field_151042_j, Items.field_151043_k, Items.field_151121_aF, Items.field_151123_aH};
        ingrTier3 = new Item[]{Items.field_151137_ax, Items.field_151114_aO, Items.field_151079_bi};
        ingrTier4 = new Item[]{Items.field_151045_i};
        towItems.put(Item.func_150898_a((Block)Blocks.field_150364_r), 2);
        towItems.put(Items.field_151044_h, 4);
        towItems.put(Items.field_151118_aC, 4);
        towItems.put(Items.field_151122_aG, 4);
        towItems.put(Item.func_150898_a((Block)Blocks.field_150366_p), 8);
        towItems.put(Items.field_151100_aR, 8);
        towItems.put(Items.field_151137_ax, 8);
        towItems.put(Items.field_151025_P, 10);
        towItems.put(Items.field_151127_ba, 10);
        towItems.put(Item.func_150898_a((Block)Blocks.field_150423_aK), 10);
        towItems.put(Items.field_151157_am, 12);
        towItems.put(Items.field_151083_be, 12);
        towItems.put(Items.field_151077_bg, 12);
        towItems.put(Items.field_151101_aQ, 12);
        towItems.put(Items.field_151042_j, 16);
        towItems.put(Item.func_150898_a((Block)Blocks.field_150352_o), 20);
        towItems.put(Items.field_151043_k, 24);
        towItems.put(Items.field_151045_i, 40);
        Item respecBook = new ItemRespecBook().func_77655_b("respecBook").func_111206_d("levelup:RespecBook").func_77637_a(CreativeTabs.field_78040_i);
        xpTalisman = new Item().func_77655_b("xpTalisman").func_111206_d("levelup:XPTalisman").func_77637_a(CreativeTabs.field_78040_i);
        GameRegistry.registerItem((Item)respecBook, (String)"Book of Unlearning");
        GameRegistry.registerItem((Item)xpTalisman, (String)"Talisman of Wonder");
        GameRegistry.addRecipe((ItemStack)new ItemStack(respecBook, 1), (Object[])new Object[]{"OEO", "DBD", "ODO", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('D'), new ItemStack(Items.field_151100_aR, 1, 0), Character.valueOf('E'), Items.field_151079_bi, Character.valueOf('B'), Items.field_151122_aG});
        ItemStack talisman = new ItemStack(xpTalisman, 1);
        GameRegistry.addRecipe((ItemStack)talisman, (Object[])new Object[]{"GG ", " R ", " GG", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('R'), Items.field_151137_ax});
        GameRegistry.addShapelessRecipe((ItemStack)talisman, (Object[])new Object[]{xpTalisman, Items.field_151044_h});
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(talisman, new Object[]{xpTalisman, "oreGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(talisman, new Object[]{xpTalisman, "oreIron"}));
        GameRegistry.addShapelessRecipe((ItemStack)talisman, (Object[])new Object[]{xpTalisman, Items.field_151045_i});
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(talisman, new Object[]{xpTalisman, "logWood"}));
        GameRegistry.addShapelessRecipe((ItemStack)talisman, (Object[])new Object[]{xpTalisman, Items.field_151118_aC});
        GameRegistry.addShapelessRecipe((ItemStack)talisman, (Object[])new Object[]{xpTalisman, Items.field_151122_aG});
        GameRegistry.addShapelessRecipe((ItemStack)talisman, (Object[])new Object[]{xpTalisman, new ItemStack(Items.field_151100_aR, 1, 4)});
        GameRegistry.addShapelessRecipe((ItemStack)talisman, (Object[])new Object[]{xpTalisman, Items.field_151137_ax});
        GameRegistry.addShapelessRecipe((ItemStack)talisman, (Object[])new Object[]{xpTalisman, Items.field_151025_P});
        GameRegistry.addShapelessRecipe((ItemStack)talisman, (Object[])new Object[]{xpTalisman, Items.field_151127_ba});
        GameRegistry.addShapelessRecipe((ItemStack)talisman, (Object[])new Object[]{xpTalisman, Items.field_151157_am});
        GameRegistry.addShapelessRecipe((ItemStack)talisman, (Object[])new Object[]{xpTalisman, Items.field_151083_be});
        GameRegistry.addShapelessRecipe((ItemStack)talisman, (Object[])new Object[]{xpTalisman, Items.field_151077_bg});
        GameRegistry.addShapelessRecipe((ItemStack)talisman, (Object[])new Object[]{xpTalisman, Items.field_151101_aQ});
        GameRegistry.addShapelessRecipe((ItemStack)talisman, (Object[])new Object[]{xpTalisman, Items.field_151042_j});
        GameRegistry.addShapelessRecipe((ItemStack)talisman, (Object[])new Object[]{xpTalisman, Items.field_151043_k});
        GameRegistry.addShapelessRecipe((ItemStack)talisman, (Object[])new Object[]{xpTalisman, Blocks.field_150423_aK});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151080_bb, 4), (Object[])new Object[]{Blocks.field_150423_aK});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150351_n, 4), (Object[])new Object[]{"##", "##", Character.valueOf('#'), Items.field_151145_ak});
        if (event.getSourceFile().getName().endsWith(".jar") && event.getSide().isClient()) {
            try {
                Class.forName("mods.mud.ModUpdateDetector").getDeclaredMethod("registerMod", ModContainer.class, String.class, String.class).invoke(null, FMLCommonHandler.instance().findContainerFor((Object)this), "https://raw.github.com/GotoLink/LevelUp/master/update.xml", "https://raw.github.com/GotoLink/LevelUp/master/changelog.md");
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    public static void refreshValues(boolean[] values) {
        allowHUD = values[0];
        renderTopLeft = values[1];
        renderExpBar = values[2];
        config.get("HUD", "allow HUD", true).set(values[0]);
        config.get("HUD", "render HUD on Top Left", true).set(values[1]);
        config.get("HUD", "render HUD on Exp Bar", true).set(values[2]);
        config.save();
    }

    public static void giveBonusCraftingXP(EntityPlayer player) {
        byte pClass = PlayerExtendedProperties.getPlayerClass(player);
        if (pClass == 3 || pClass == 6 || pClass == 9 || pClass == 12) {
            Map<String, int[]> counters = PlayerExtendedProperties.getCounterMap(player);
            int[] bonus = counters.get(PlayerExtendedProperties.counters[2]);
            if (bonus == null || bonus.length == 0) {
                bonus = new int[]{0, 0, 0, 0};
            }
            if (bonus[1] < 4) {
                bonus[1] = bonus[1] + 1;
            } else {
                bonus[1] = 0;
                player.func_71023_q(2);
            }
            counters.put(PlayerExtendedProperties.counters[2], bonus);
        }
    }

    public static void giveBonusMiningXP(EntityPlayer player) {
        byte pClass = PlayerExtendedProperties.getPlayerClass(player);
        if (pClass == 1 || pClass == 4 || pClass == 7 || pClass == 10) {
            Map<String, int[]> counters = PlayerExtendedProperties.getCounterMap(player);
            int[] bonus = counters.get(PlayerExtendedProperties.counters[2]);
            if (bonus == null || bonus.length == 0) {
                bonus = new int[]{0, 0, 0};
            }
            if (bonus[0] < 4) {
                bonus[0] = bonus[0] + 1;
            } else {
                bonus[0] = 0;
                player.func_71023_q(2);
            }
            counters.put(PlayerExtendedProperties.counters[2], bonus);
        }
    }

    public static void giveCraftingXP(EntityPlayer player, ItemStack itemstack) {
        Item[][] ai = new Item[][]{ingrTier1, ingrTier2, ingrTier3, ingrTier4};
        for (int i = 0; i < 4; ++i) {
            if (!Arrays.asList(ai[i]).contains(itemstack.func_77973_b())) continue;
            LevelUp.incrementCraftCounter(player, i);
        }
    }

    public static void incrementCraftCounter(EntityPlayer player, int i) {
        Map<String, int[]> counters = PlayerExtendedProperties.getCounterMap(player);
        int[] craft = counters.get(PlayerExtendedProperties.counters[1]);
        if (craft.length <= i) {
            int[] craftnew = new int[i + 1];
            System.arraycopy(craft, 0, craftnew, 0, craft.length);
            counters.put(PlayerExtendedProperties.counters[0], craftnew);
            craft = craftnew;
        }
        int n = i;
        craft[n] = craft[n] + 1;
        boolean flag = false;
        for (float f = (float)Math.pow(2.0, 3 - i); f <= (float)craft[i]; f += 0.5f) {
            player.func_71023_q(1);
            flag = true;
        }
        if (flag) {
            craft[i] = 0;
        }
        counters.put(PlayerExtendedProperties.counters[1], craft);
    }

    public static void incrementOreCounter(EntityPlayer player, int i) {
        Map<String, int[]> counters = PlayerExtendedProperties.getCounterMap(player);
        int[] ore = counters.get(PlayerExtendedProperties.counters[0]);
        if (ore.length <= i) {
            int[] orenew = new int[i + 1];
            System.arraycopy(ore, 0, orenew, 0, ore.length);
            counters.put(PlayerExtendedProperties.counters[0], orenew);
            ore = orenew;
        }
        int n = i;
        ore[n] = ore[n] + 1;
        LevelUp.giveBonusMiningXP(player);
        boolean flag = false;
        for (float f = (float)Math.pow(2.0, 3 - i) / 2.0f; f <= (float)ore[i]; f += 0.5f) {
            player.func_71023_q(1);
            flag = true;
        }
        if (flag) {
            ore[i] = 0;
        }
        counters.put(PlayerExtendedProperties.counters[0], ore);
    }

    public static boolean isTalismanRecipe(IInventory iinventory) {
        for (int i = 0; i < iinventory.func_70302_i_(); ++i) {
            if (iinventory.func_70301_a(i) == null || iinventory.func_70301_a(i).func_77973_b() != xpTalisman) continue;
            return true;
        }
        return false;
    }

    public static void takenFromCrafting(EntityPlayer player, ItemStack itemstack, IInventory iinventory) {
        if (LevelUp.isTalismanRecipe(iinventory)) {
            for (int i = 0; i < iinventory.func_70302_i_(); ++i) {
                ItemStack itemstack1 = iinventory.func_70301_a(i);
                if (itemstack1 == null || !towItems.containsKey(itemstack1.func_77973_b())) continue;
                player.func_71023_q((int)Math.floor((double)(itemstack1.field_77994_a * towItems.get(itemstack1.func_77973_b())) / 4.0));
                iinventory.func_70301_a((int)i).field_77994_a = 0;
            }
        } else {
            for (int j = 0; j < iinventory.func_70302_i_(); ++j) {
                ItemStack itemstack2 = iinventory.func_70301_a(j);
                if (itemstack2 == null || itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150340_R) || itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150339_S) || itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150484_ah)) continue;
                LevelUp.giveCraftingXP(player, itemstack2);
                LevelUp.giveBonusCraftingXP(player);
            }
        }
    }

    static {
        towItems = new HashMap<Item, Integer>();
    }
}

