/*
 * Decompiled with CFR 0.152.
 */
package assets.levelup;

import assets.levelup.PlayerExtendedProperties;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.EnumAction;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class BowEventHandler {
    public static final BowEventHandler INSTANCE = new BowEventHandler();

    private BowEventHandler() {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onSpawn(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityArrow) {
            int archer;
            EntityArrow arrow = (EntityArrow)event.entity;
            if (arrow.field_70250_c instanceof EntityPlayer && (archer = BowEventHandler.getArcherSkill((EntityPlayer)arrow.field_70250_c)) != 0) {
                arrow.field_70159_w *= (double)(1.0f + (float)archer / 100.0f);
                arrow.field_70181_x *= (double)(1.0f + (float)archer / 100.0f);
                arrow.field_70179_y *= (double)(1.0f + (float)archer / 100.0f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onBowUse(PlayerUseItemEvent.Start event) {
        int archer;
        if (event.item != null && event.item.func_77976_d() == 1 && event.item.func_77975_n() == EnumAction.BOW && (archer = BowEventHandler.getArcherSkill(event.entityPlayer)) != 0 && event.duration > archer / 5) {
            event.duration -= archer / 5;
        }
    }

    public static int getArcherSkill(EntityPlayer player) {
        return PlayerExtendedProperties.getSkillFromIndex(player, 5);
    }
}

