/*
 * Decompiled with CFR 0.152.
 */
package assets.levelup;

import assets.levelup.ClassBonus;
import assets.levelup.LevelUp;
import assets.levelup.PlayerEventHandler;
import assets.levelup.PlayerExtendedProperties;
import assets.levelup.SkillPacketHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.relauncher.Side;

public final class FMLEventHandler {
    private static final UUID speedID = UUID.fromString("4f7637c8-6106-4050-96cb-e47f83bfa415");
    private static final UUID sneakID = UUID.fromString("a4dc0b04-f78a-43f6-8805-5ebfbab10b18");
    public static final FMLEventHandler INSTANCE = new FMLEventHandler();
    private List<IPlantable> blackListedCrops;

    private FMLEventHandler() {
    }

    @SubscribeEvent
    public void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            int skill;
            double diff;
            int time;
            int bonus;
            ItemStack stack;
            TileEntityFurnace furnace;
            EntityPlayer player = event.player;
            if (!player.field_70170_p.field_72995_K && player.field_71070_bA instanceof ContainerFurnace && (furnace = (TileEntityFurnace)((ContainerFurnace)player.field_71070_bA).field_75158_e) != null && furnace.func_145950_i() && furnace.func_145948_k() && (stack = furnace.func_70301_a(0)) != null && (bonus = stack.func_77973_b().func_77661_b(stack) == EnumAction.EAT ? FMLEventHandler.getSkill(player, 7) : FMLEventHandler.getSkill(player, 4)) > 10 && (time = player.func_70681_au().nextInt(bonus / 10)) != 0 && furnace.func_174887_a_(2) + time < furnace.func_174887_a_(3)) {
                furnace.func_174885_b(2, furnace.func_174887_a_(2) + time);
            }
            if (PlayerExtendedProperties.getPlayerClass(player) != 0 && (diff = PlayerEventHandler.xpPerLevel * (double)(player.field_71068_ca - 4) + (double)ClassBonus.getBonusPoints() - (double)PlayerExtendedProperties.from(player).getSkillPoints()) >= 1.0) {
                PlayerExtendedProperties.from(player).addToSkill("XP", (int)Math.floor(diff));
            }
            if (!player.field_70170_p.field_72995_K && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemHoe && (skill = FMLEventHandler.getSkill(player, 9)) != 0 && player.func_70681_au().nextFloat() <= (float)skill / 2500.0f) {
                this.growCropsAround(player.field_70170_p, skill / 4, player);
            }
            IAttributeInstance atinst = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
            skill = FMLEventHandler.getSkill(player, 6);
            if (skill != 0) {
                AttributeModifier mod = new AttributeModifier(speedID, "SprintingSkillSpeed", (double)((float)skill / 100.0f), 2);
                if (player.func_70051_ag()) {
                    if (atinst.func_111127_a(speedID) == null) {
                        atinst.func_111121_a(mod);
                    }
                } else if (atinst.func_111127_a(speedID) != null) {
                    atinst.func_111124_b(mod);
                }
                if (player.field_70143_R > 0.0f) {
                    player.field_70143_R *= 1.0f - (float)(skill / 5) / 100.0f;
                }
            }
            if ((skill = FMLEventHandler.getSkill(player, 8)) != 0) {
                AttributeModifier mod = new AttributeModifier(sneakID, "SneakingSkillSpeed", (double)((float)(2 * skill) / 100.0f), 2);
                if (player.func_70093_af()) {
                    if (atinst.func_111127_a(sneakID) == null) {
                        atinst.func_111121_a(mod);
                    }
                } else if (atinst.func_111127_a(sneakID) != null) {
                    atinst.func_111124_b(mod);
                }
            }
        }
    }

    private void growCropsAround(World world, int range, EntityPlayer player) {
        int posX = (int)player.field_70165_t;
        int posY = (int)player.field_70163_u;
        int posZ = (int)player.field_70161_v;
        int dist = range / 2 + 2;
        for (Object o : BlockPos.func_177980_a((BlockPos)new BlockPos(posX - dist, posY - dist, posZ - dist), (BlockPos)new BlockPos(posX + dist + 1, posY + dist + 1, posZ + dist + 1))) {
            Block soil;
            BlockPos pos = (BlockPos)o;
            if (!world.func_175623_d(pos.func_177984_a())) continue;
            Block block = world.func_180495_p(pos).func_177230_c();
            if (!(block instanceof IPlantable) || this.blackListedCrops.contains(block) || (soil = world.func_180495_p(pos.func_177977_b()).func_177230_c()).isAir((IBlockAccess)world, pos.func_177977_b()) || !soil.canSustainPlant((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)block)) break;
            ItemDye.applyBonemeal((ItemStack)new ItemStack(Items.field_151100_aR, 1, 15), (World)world, (BlockPos)pos, (EntityPlayer)player);
            break;
        }
    }

    public void addCropsToBlackList(List<String> blackList) {
        if (this.blackListedCrops == null) {
            this.blackListedCrops = new ArrayList<IPlantable>(blackList.size());
        }
        for (String txt : blackList) {
            Object crop = GameData.getBlockRegistry().func_82594_a((Object)txt);
            if (!(crop instanceof IPlantable)) continue;
            this.blackListedCrops.add((IPlantable)crop);
        }
    }

    public static int getSkill(EntityPlayer player, int id) {
        return PlayerExtendedProperties.getSkillFromIndex(player, id);
    }

    @SubscribeEvent
    public void onSmelting(PlayerEvent.ItemSmeltedEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            EntityItem entityitem;
            Random random = event.player.func_70681_au();
            ItemStack add = null;
            if (event.smelting.func_77975_n() == EnumAction.EAT) {
                if (random.nextFloat() <= (float)FMLEventHandler.getSkill(event.player, 7) / 200.0f) {
                    add = event.smelting.func_77946_l();
                }
            } else if (random.nextFloat() <= (float)FMLEventHandler.getSkill(event.player, 4) / 200.0f) {
                add = event.smelting.func_77946_l();
            }
            if ((entityitem = ForgeHooks.onPlayerTossEvent((EntityPlayer)event.player, (ItemStack)add, (boolean)true)) != null) {
                entityitem.func_174868_q();
                entityitem.func_145797_a(event.player.func_70005_c_());
            }
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        LevelUp.takenFromCrafting(event.player, event.crafting, event.craftMatrix);
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.loadPlayer(event.player);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.loadPlayer(event.player);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            this.loadPlayer(event.player);
            LevelUp.configChannel.sendTo(SkillPacketHandler.getConfigPacket(LevelUp.instance.getServerProperties()), (EntityPlayerMP)event.player);
        }
    }

    public void loadPlayer(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            byte cl = PlayerExtendedProperties.getPlayerClass(player);
            int[] data = PlayerExtendedProperties.from(player).getPlayerData(false);
            LevelUp.initChannel.sendTo(SkillPacketHandler.getPacket(Side.CLIENT, 0, cl, data), (EntityPlayerMP)player);
        }
    }
}

