/*
 * Decompiled with CFR 0.152.
 */
package assets.levelup;

import assets.levelup.ClassBonus;
import assets.levelup.FMLEventHandler;
import assets.levelup.LevelUp;
import assets.levelup.PlayerEventHandler;
import assets.levelup.PlayerExtendedProperties;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class LevelUpHUD
extends Gui {
    public static final LevelUpHUD INSTANCE = new LevelUpHUD();
    private float val = 0.7f;
    private float valIncr = 0.005f;

    private LevelUpHUD() {
    }

    public void addToText(List<String> left) {
        byte playerClass = PlayerExtendedProperties.getPlayerClass(LevelUp.proxy.getPlayer());
        if (playerClass != 0) {
            int skillXP;
            if (!LevelUp.renderExpBar && (skillXP = PlayerExtendedProperties.from(LevelUp.proxy.getPlayer()).getSkillFromIndex("XP")) > 0) {
                left.add(StatCollector.func_74837_a((String)"hud.skill.text1", (Object[])new Object[]{skillXP}));
            }
            left.add(StatCollector.func_74837_a((String)"hud.skill.text2", (Object[])new Object[]{StatCollector.func_74838_a((String)("class" + playerClass + ".name"))}));
        } else if (LevelUpHUD.canSelectClass() && !LevelUp.renderExpBar) {
            left.add(StatCollector.func_74838_a((String)"hud.skill.select"));
        }
    }

    @SubscribeEvent
    public void renderLvlUpHUD(RenderGameOverlayEvent.Pre event) {
        if (LevelUp.allowHUD && LevelUp.proxy.getPlayer() != null) {
            if (LevelUp.renderTopLeft && event.type == RenderGameOverlayEvent.ElementType.TEXT) {
                this.addToText(((RenderGameOverlayEvent.Text)event).left);
            }
            if (LevelUp.renderExpBar && event.type == RenderGameOverlayEvent.ElementType.EXPERIENCE) {
                this.addToExpBar(event.resolution);
            }
        }
    }

    @SubscribeEvent
    public void onFOV(FOVUpdateEvent event) {
        if (!LevelUp.changeFOV && !event.entity.func_71039_bw()) {
            int skill = 0;
            if (event.entity.func_70093_af()) {
                skill = 2 * FMLEventHandler.getSkill(event.entity, 8);
            } else if (event.entity.func_70051_ag()) {
                skill = FMLEventHandler.getSkill(event.entity, 6);
            }
            if (skill > 0) {
                event.newfov -= 0.5f;
                event.newfov *= 1.0f / (1.0f + (float)skill / 100.0f);
                event.newfov += 0.5f;
            }
        }
    }

    private void addToExpBar(ScaledResolution res) {
        this.val += this.valIncr;
        if (this.val >= 1.0f || this.val <= 0.4f) {
            this.valIncr *= -1.0f;
        }
        if (this.val > 1.0f) {
            this.val = 1.0f;
        }
        if (this.val < 0.4f) {
            this.val = 0.4f;
        }
        String text = null;
        if (LevelUpHUD.canShowSkills()) {
            int skillXP = PlayerExtendedProperties.from(LevelUp.proxy.getPlayer()).getSkillFromIndex("XP");
            if (skillXP > 0) {
                text = StatCollector.func_74837_a((String)"hud.skill.text1", (Object[])new Object[]{skillXP});
            }
        } else if (LevelUpHUD.canSelectClass()) {
            text = StatCollector.func_74838_a((String)"hud.skill.select");
        }
        int x = (res.func_78326_a() - Minecraft.func_71410_x().field_71466_p.func_78256_a(text)) / 2;
        int y = res.func_78328_b() - 29;
        if (text != null) {
            int col = Color.HSBtoRGB(0.2929688f, 1.0f, this.val) & 0xFFFFFF;
            Minecraft.func_71410_x().field_71466_p.func_78276_b(text, x, y, col);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    public static boolean canSelectClass() {
        if (LevelUp.proxy.getPlayer().field_71068_ca >= 4) {
            return true;
        }
        int points = PlayerExtendedProperties.from(LevelUp.proxy.getPlayer()).getSkillPoints();
        return (double)points > 4.0 * PlayerEventHandler.xpPerLevel || points > ClassBonus.getBonusPoints();
    }

    public static boolean canShowSkills() {
        return PlayerExtendedProperties.from(LevelUp.proxy.getPlayer()).hasClass();
    }
}

