/*
 * Decompiled with CFR 0.152.
 */
package assets.levelup;

import assets.levelup.LevelUp;
import assets.levelup.PlayerExtendedProperties;
import com.google.common.collect.Sets;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockStone;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

public final class PlayerEventHandler {
    public static boolean oldSpeedDigging = true;
    public static boolean oldSpeedRedstone = true;
    public static float resetSkillOnDeath = 0.0f;
    public static boolean resetClassOnDeath = false;
    public static boolean noPlaceDuplicate = true;
    public static double xpPerLevel = 3.0;
    public static final int minLevel = 4;
    private static ItemStack[] lootList = new ItemStack[]{new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151120_aE), new ItemStack(Items.field_151032_g), new ItemStack(Items.field_151034_e), new ItemStack(Items.field_151133_ar), new ItemStack(Items.field_151124_az), new ItemStack(Items.field_151079_bi), new ItemStack((Item)Items.field_151112_aM), new ItemStack((Item)Items.field_151023_V), new ItemStack(Items.field_151042_j)};
    private static Map<Block, Integer> blockToCounter = new IdentityHashMap<Block, Integer>();
    private static ItemStack[] digLoot;
    private static ItemStack[] digLoot1;
    private static ItemStack[] digLoot2;
    private static ItemStack[] digLoot3;
    private static Set<Block> ores;

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onBreak(PlayerEvent.BreakSpeed event) {
        ItemStack itemstack = event.entityPlayer.func_71045_bC();
        Block block = event.state.func_177230_c();
        if (itemstack != null) {
            if (oldSpeedDigging && itemstack.func_77973_b() instanceof ItemSpade) {
                if (block instanceof BlockDirt || block instanceof BlockGravel) {
                    event.newSpeed = event.newSpeed * itemstack.func_150997_a(block) / 0.5f;
                }
            } else if (oldSpeedRedstone && itemstack.func_77973_b() instanceof ItemPickaxe && block instanceof BlockRedstoneOre) {
                event.newSpeed = event.newSpeed * itemstack.func_150997_a(block) / 3.0f;
            }
        }
        if (block instanceof BlockStone || block == Blocks.field_150347_e || block == Blocks.field_150343_Z || block instanceof BlockOre) {
            event.newSpeed += (float)(PlayerEventHandler.getSkill(event.entityPlayer, 0) / 5) * 0.2f;
        } else if (block.func_149688_o() == Material.field_151575_d) {
            event.newSpeed += (float)(PlayerEventHandler.getSkill(event.entityPlayer, 3) / 5) * 0.2f;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDeath(LivingDeathEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            if (resetClassOnDeath) {
                PlayerExtendedProperties.from((EntityPlayer)event.entityLiving).setPlayerClass((byte)0);
            }
            if (resetSkillOnDeath > 0.0f) {
                PlayerExtendedProperties.from((EntityPlayer)event.entityLiving).takeSkillFraction(resetSkillOnDeath);
            }
        } else if (event.entityLiving instanceof EntityMob && event.source.func_76346_g() instanceof EntityPlayer) {
            LevelUp.giveBonusFightingXP((EntityPlayer)event.source.func_76346_g());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onInteract(PlayerInteractEvent event) {
        if (event.useItem != Event.Result.DENY) {
            ItemStack itemStack;
            if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR) {
                int loot;
                EntityFishHook hook = event.entityPlayer.field_71104_cf;
                if (hook != null && hook.field_146043_c == null && hook.field_146045_ax > 0 && (loot = PlayerEventHandler.getFishingLoot(event.entityPlayer)) >= 0) {
                    ItemStack stack = event.entityPlayer.field_71071_by.func_70448_g();
                    int i = stack.field_77994_a;
                    int j = stack.func_77952_i();
                    stack.func_77972_a(loot, (EntityLivingBase)event.entityPlayer);
                    event.entityPlayer.func_71038_i();
                    event.entityPlayer.field_71071_by.func_70299_a(event.entityPlayer.field_71071_by.field_70461_c, stack);
                    if (event.entityPlayer.field_71075_bZ.field_75098_d) {
                        stack.field_77994_a = i;
                        if (stack.func_77984_f()) {
                            stack.func_77964_b(j);
                        }
                    }
                    if (stack.field_77994_a <= 0) {
                        event.entityPlayer.field_71071_by.func_70299_a(event.entityPlayer.field_71071_by.field_70461_c, null);
                        MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(event.entityPlayer, stack));
                    }
                    if (!event.entityPlayer.func_71039_bw() && event.entityPlayer instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)event.entityPlayer).func_71120_a(event.entityPlayer.field_71069_bz);
                    }
                    event.useItem = Event.Result.DENY;
                    if (!hook.field_70170_p.field_72995_K) {
                        EntityItem entityitem = new EntityItem(hook.field_70170_p, hook.field_70165_t, hook.field_70163_u, hook.field_70161_v, lootList[loot]);
                        double d5 = hook.field_146042_b.field_70165_t - hook.field_70165_t;
                        double d6 = hook.field_146042_b.field_70163_u - hook.field_70163_u;
                        double d7 = hook.field_146042_b.field_70161_v - hook.field_70161_v;
                        double d8 = MathHelper.func_76133_a((double)(d5 * d5 + d6 * d6 + d7 * d7));
                        double d9 = 0.1;
                        entityitem.field_70159_w = d5 * d9;
                        entityitem.field_70181_x = d6 * d9 + (double)MathHelper.func_76133_a((double)d8) * 0.08;
                        entityitem.field_70179_y = d7 * d9;
                        hook.field_70170_p.func_72838_d((Entity)entityitem);
                        hook.field_146042_b.field_70170_p.func_72838_d((Entity)new EntityXPOrb(hook.field_146042_b.field_70170_p, hook.field_146042_b.field_70165_t, hook.field_146042_b.field_70163_u + 0.5, hook.field_146042_b.field_70161_v + 0.5, event.entityPlayer.func_70681_au().nextInt(6) + 1));
                    }
                }
            } else if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && noPlaceDuplicate && (itemStack = event.entityPlayer.field_71071_by.func_70448_g()) != null && itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("NoPlacing")) {
                event.useItem = Event.Result.DENY;
            }
        }
    }

    @SubscribeEvent
    public void onHarvest(BlockEvent.HarvestDropsEvent event) {
        if (event.harvester != null && !event.world.field_72995_K) {
            Random random = event.harvester.func_70681_au();
            if (event.state.func_177230_c() instanceof BlockOre || event.state.func_177230_c() instanceof BlockRedstoneOre || ores.contains(event.state.func_177230_c())) {
                int skill = PlayerEventHandler.getSkill(event.harvester, 0);
                if (!blockToCounter.containsKey(event.state.func_177230_c())) {
                    blockToCounter.put(event.state.func_177230_c(), blockToCounter.size());
                }
                if (!event.isSilkTouching) {
                    LevelUp.incrementOreCounter(event.harvester, blockToCounter.get(event.state.func_177230_c()));
                }
                if (random.nextDouble() <= (double)skill / 200.0) {
                    int qutity;
                    Item ID;
                    boolean foundBlock = false;
                    for (ItemStack stack : event.drops) {
                        if (stack == null || event.state.func_177230_c() != Block.func_149634_a((Item)stack.func_77973_b())) continue;
                        this.writeNoPlacing(stack);
                        ++stack.field_77994_a;
                        foundBlock = true;
                        break;
                    }
                    if (!foundBlock && (ID = event.state.func_177230_c().func_180660_a(event.state, random, 0)) != null && (qutity = event.state.func_177230_c().quantityDropped(event.state, 0, random)) > 0) {
                        event.drops.add(new ItemStack(ID, qutity, event.state.func_177230_c().func_180651_a(event.state)));
                    }
                }
            } else if (event.state.func_177230_c() instanceof BlockLog) {
                int skill = PlayerEventHandler.getSkill(event.harvester, 3);
                if (random.nextDouble() <= (double)skill / 150.0) {
                    ItemStack planks = null;
                    for (ItemStack stack : event.drops) {
                        if (stack == null || event.state.func_177230_c() != Block.func_149634_a((Item)stack.func_77973_b()) || (planks = this.getPlanks(event.harvester, stack.func_77946_l())) == null) continue;
                        planks.field_77994_a = 2;
                        break;
                    }
                    if (planks != null) {
                        event.drops.add(planks);
                    }
                }
                if (random.nextDouble() <= (double)skill / 150.0) {
                    event.drops.add(new ItemStack(Items.field_151055_y, 2));
                }
            } else if (event.state.func_177230_c().func_149688_o() == Material.field_151578_c) {
                int skill = PlayerEventHandler.getSkill(event.harvester, 11);
                if (random.nextFloat() <= (float)skill / 200.0f) {
                    ItemStack[] aitemstack4 = digLoot;
                    float f = random.nextFloat();
                    if (f <= 0.002f) {
                        aitemstack4 = digLoot3;
                    } else if (f <= 0.1f) {
                        aitemstack4 = digLoot2;
                    } else if (f <= 0.4f) {
                        aitemstack4 = digLoot1;
                    }
                    this.removeFromList(event.drops, event.state.func_177230_c());
                    ItemStack itemstack = aitemstack4[random.nextInt(aitemstack4.length)];
                    int size = itemstack.field_77994_a;
                    ItemStack toDrop = itemstack.func_77946_l();
                    toDrop.field_77994_a = 1;
                    if (toDrop.func_77958_k() > 20) {
                        toDrop.func_77964_b(random.nextInt(80) + 20);
                    } else {
                        for (int i1 = 0; i1 < size - 1; ++i1) {
                            if (!(random.nextFloat() < 0.5f)) continue;
                            event.drops.add(toDrop.func_77946_l());
                        }
                    }
                    event.drops.add(toDrop);
                }
            } else if (event.state.func_177230_c() instanceof BlockGravel) {
                int skill = PlayerEventHandler.getSkill(event.harvester, 11);
                if (random.nextInt(10) < skill / 5) {
                    this.removeFromList(event.drops, event.state.func_177230_c());
                    event.drops.add(new ItemStack(Items.field_151145_ak));
                }
            }
        }
    }

    private void removeFromList(List<ItemStack> drops, Block block) {
        Iterator<ItemStack> itr = drops.iterator();
        while (itr.hasNext()) {
            ItemStack drop = itr.next();
            if (drop == null || block != Block.func_149634_a((Item)drop.func_77973_b())) continue;
            itr.remove();
        }
    }

    private void writeNoPlacing(ItemStack toDrop) {
        if (!noPlaceDuplicate) {
            return;
        }
        NBTTagCompound tagCompound = toDrop.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74757_a("NoPlacing", true);
        toDrop.func_77982_d(tagCompound);
    }

    private ItemStack getPlanks(EntityPlayer player, ItemStack drop) {
        InventoryCrafting craft = new ContainerPlayer((InventoryPlayer)player.field_71071_by, (boolean)(!player.field_70170_p.field_72995_K ? true : false), (EntityPlayer)player).field_75181_e;
        craft.func_70299_a(1, drop);
        return CraftingManager.func_77594_a().func_82787_a(craft, player.field_70170_p);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        if (!event.world.field_72995_K && event.getPlayer() != null) {
            if (event.state.func_177230_c() instanceof BlockCrops || event.state.func_177230_c() instanceof BlockStem) {
                if (!((IGrowable)event.state.func_177230_c()).func_176473_a(event.world, event.pos, event.state, false)) {
                    this.doCropDrops(event);
                }
            } else if (event.state.func_177230_c() instanceof BlockMelon) {
                this.doCropDrops(event);
            }
        }
    }

    private void doCropDrops(BlockEvent.BreakEvent event) {
        Random random = event.getPlayer().func_70681_au();
        int skill = PlayerEventHandler.getSkill(event.getPlayer(), 9);
        if (random.nextInt(10) < skill / 5) {
            Item ID = event.state.func_177230_c().func_180660_a(event.state, random, 0);
            if (ID == null) {
                if (event.state.func_177230_c() == Blocks.field_150393_bb) {
                    ID = Items.field_151080_bb;
                } else if (event.state.func_177230_c() == Blocks.field_150394_bc) {
                    ID = Items.field_151081_bc;
                }
            }
            if (ID != null) {
                event.world.func_72838_d((Entity)new EntityItem(event.world, (double)event.pos.func_177958_n(), (double)event.pos.func_177956_o(), (double)event.pos.func_177952_p(), new ItemStack(ID, 1, event.state.func_177230_c().func_180651_a(event.state))));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerConstruction(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer) {
            PlayerExtendedProperties.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.wasDeath || !resetClassOnDeath || resetSkillOnDeath < 1.0f) {
            NBTTagCompound data = new NBTTagCompound();
            PlayerExtendedProperties.from(event.original).saveNBTData(data);
            PlayerExtendedProperties.from(event.entityPlayer).loadNBTData(data);
        }
    }

    @SubscribeEvent
    public void onOreRegister(OreDictionary.OreRegisterEvent event) {
        Block ore;
        if (event.Name.startsWith("ore") && event.Ore != null && event.Ore.func_77973_b() != null && (ore = Block.func_149634_a((Item)event.Ore.func_77973_b())) != Blocks.field_150350_a && !(ore instanceof BlockOre) && !(ore instanceof BlockRedstoneOre)) {
            ores.add(ore);
        }
    }

    public static int getFishingLoot(EntityPlayer player) {
        if (player.func_70681_au().nextDouble() > (double)(PlayerEventHandler.getSkill(player, 10) / 5) * 0.05) {
            return -1;
        }
        return player.func_70681_au().nextInt(lootList.length);
    }

    public static int getSkill(EntityPlayer player, int id) {
        return PlayerExtendedProperties.getSkillFromIndex(player, id);
    }

    static {
        blockToCounter.put(Blocks.field_150365_q, 0);
        blockToCounter.put(Blocks.field_150369_x, 1);
        blockToCounter.put(Blocks.field_150450_ax, 2);
        blockToCounter.put(Blocks.field_150366_p, 3);
        blockToCounter.put(Blocks.field_150352_o, 4);
        blockToCounter.put(Blocks.field_150412_bA, 5);
        blockToCounter.put(Blocks.field_150482_ag, 6);
        blockToCounter.put(Blocks.field_150449_bY, 7);
        digLoot = new ItemStack[]{new ItemStack(Items.field_151119_aD, 8), new ItemStack(Items.field_151054_z, 2), new ItemStack(Items.field_151044_h, 4), new ItemStack(Items.field_151159_an), new ItemStack(Items.field_151055_y, 4), new ItemStack(Items.field_151007_F, 2)};
        digLoot1 = new ItemStack[]{new ItemStack(Items.field_151052_q), new ItemStack(Items.field_151051_r), new ItemStack(Items.field_151050_s), new ItemStack(Items.field_151049_t)};
        digLoot2 = new ItemStack[]{new ItemStack(Items.field_151123_aH, 2), new ItemStack(Items.field_151137_ax, 8), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151043_k)};
        digLoot3 = new ItemStack[]{new ItemStack(Items.field_151045_i)};
        ores = Sets.newIdentityHashSet();
    }
}

