/*
 * Decompiled with CFR 0.152.
 */
package levelup;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import levelup.ClassBonus;
import levelup.SkillPacketHandler;
import levelup.api.IProcessor;
import levelup.api.LevelUpAPI;
import levelup.capabilities.LevelUpCapability;
import levelup.event.BowEventHandler;
import levelup.event.FMLEventHandler;
import levelup.event.FightEventHandler;
import levelup.event.PlayerEventHandler;
import levelup.item.ItemRespecBook;
import levelup.minetweaker.MineTweaker;
import levelup.player.IPlayerClass;
import levelup.player.PlayerExtendedProperties;
import levelup.proxy.SkillProxy;
import levelup.util.CraftingBlacklist;
import levelup.util.PlankCache;
import levelup.util.UtilRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod(modid="levelup", name="LevelUp!", version="${version}", guiFactory="levelup.ConfigLevelUp", acceptedMinecraftVersions="[1.10.2]")
public final class LevelUp {
    public static final String ID = "levelup";
    @Mod.Instance(value="levelup")
    public static LevelUp instance;
    @SidedProxy(clientSide="levelup.proxy.SkillClientProxy", serverSide="levelup.proxy.SkillProxy")
    public static SkillProxy proxy;
    private Property[] clientProperties;
    private Property[] serverProperties;
    private static Item xpTalisman;
    private static Item respecBook;
    private static Map<Object, Integer> towItems;
    private static List[] tiers;
    private static Configuration config;
    public static boolean allowHUD;
    public static boolean renderTopLeft;
    public static boolean renderExpBar;
    public static boolean changeFOV;
    public static boolean oreNoPlace;
    private static boolean bonusMiningXP;
    private static boolean bonusCraftingXP;
    private static boolean bonusFightingXP;
    private static boolean oreMiningXP;
    public static FMLEventChannel initChannel;
    public static FMLEventChannel skillChannel;
    public static FMLEventChannel classChannel;
    public static FMLEventChannel configChannel;

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)BowEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)FightEventHandler.INSTANCE);
        SkillPacketHandler sk = new SkillPacketHandler();
        initChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(SkillPacketHandler.CHAN[0]);
        initChannel.register((Object)sk);
        classChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(SkillPacketHandler.CHAN[1]);
        classChannel.register((Object)sk);
        skillChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(SkillPacketHandler.CHAN[2]);
        skillChannel.register((Object)sk);
        configChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(SkillPacketHandler.CHAN[3]);
        configChannel.register((Object)sk);
        proxy.registerGui();
        if (xpTalisman != null) {
            proxy.register(xpTalisman, "levelup:xp_talisman");
        }
        if (respecBook != null) {
            proxy.register(respecBook, "levelup:respec_book");
        }
        UtilRegistry.init();
        if (Loader.isModLoaded((String)"MineTweaker3")) {
            MineTweaker.init();
        }
        for (BlockPlanks.EnumType type : BlockPlanks.EnumType.values()) {
            ItemStack log = null;
            ItemStack plank = new ItemStack(Blocks.field_150344_f, 2, type.func_176839_a());
            log = type.func_176839_a() < 4 ? new ItemStack(Blocks.field_150364_r, 1, type.func_176839_a()) : new ItemStack(Blocks.field_150363_s, 1, type.func_176839_a() - 4);
            Block block = ((ItemBlock)log.func_77973_b()).func_179223_d();
            PlankCache.addBlock(block, log.func_77960_j(), plank);
        }
        List logs = OreDictionary.getOres((String)"logWood");
        for (ItemStack log : logs) {
            Block block;
            if (log.func_77973_b() == null || !(log.func_77973_b() instanceof ItemBlock) || (block = ((ItemBlock)log.func_77973_b()).func_179223_d()).getRegistryName().func_110624_b().equals("minecraft")) continue;
            if (log.func_77952_i() == Short.MAX_VALUE) {
                for (int i = 0; i < 4; ++i) {
                    ItemStack planks = LevelUp.getRecipeOutput(new ItemStack(log.func_77973_b(), 1, i));
                    if (planks == null) continue;
                    ItemStack cache = new ItemStack(planks.func_77973_b(), 2, planks.func_77960_j());
                    PlankCache.addBlock(block, i, cache);
                }
                continue;
            }
            ItemStack planks = LevelUp.getRecipeOutput(log);
            if (planks == null) continue;
            ItemStack cache = new ItemStack(planks.func_77973_b(), 2, planks.func_77960_j());
            PlankCache.addBlock(block, log.func_77960_j(), cache);
        }
        PlayerEventHandler.registerOres();
    }

    private static ItemStack getRecipeOutput(ItemStack input) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe recipe : recipes) {
            ShapelessRecipes shapeless;
            if (recipe instanceof ShapelessRecipes) {
                shapeless = (ShapelessRecipes)recipe;
                if (shapeless.field_77579_b.size() != 1 || !((ItemStack)shapeless.field_77579_b.get(0)).func_77969_a(input)) continue;
                return shapeless.func_77571_b();
            }
            if (!(recipe instanceof ShapelessOreRecipe) || (shapeless = (ShapelessOreRecipe)recipe).func_77570_a() != 1 || !(shapeless.getInput().get(0) instanceof ItemStack) || !((ItemStack)shapeless.getInput().get(0)).func_77969_a(input)) continue;
            return shapeless.func_77571_b();
        }
        return null;
    }

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.addCustomCategoryComment("HUD", "Entirely client side. No need to sync.");
        this.initClientProperties();
        config.addCustomCategoryComment("Items", "Need to be manually synced to the client on a dedicated server");
        config.addCustomCategoryComment("Cheats", "Will be automatically synced to the client on a dedicated server");
        this.initServerProperties();
        boolean talismanEnabled = config.getBoolean("Enable Talisman", "Items", true, "Enable item and related recipes");
        boolean bookEnabled = config.getBoolean("Enable Unlearning Book", "Items", true, "Enable item and related recipe");
        boolean legacyRecipes = config.getBoolean("Enable Recipes", "Items", true, "Enable legacy pumpkin and flint recipes");
        this.useServerProperties();
        CapabilityManager.INSTANCE.register(IPlayerClass.class, new LevelUpCapability.CapabilityPlayerClass(), PlayerExtendedProperties.class);
        CapabilityManager.INSTANCE.register(IProcessor.class, new LevelUpCapability.CapabilityProcessorClass(), LevelUpCapability.CapabilityProcessorDefault.class);
        List<String> blackList = Arrays.asList(config.getStringList("Crops for farming", "BlackList", new String[]{""}, "That won't be affected by farming growth skill, uses internal block name. No sync to client needed."));
        FMLEventHandler.INSTANCE.addCropsToBlackList(blackList);
        if (config.hasChanged()) {
            config.save();
        }
        if (talismanEnabled) {
            towItems = new HashMap<Object, Integer>();
            xpTalisman = new Item().func_77655_b("xpTalisman").func_77637_a(CreativeTabs.field_78040_i);
            GameRegistry.register((IForgeRegistryEntry)xpTalisman.setRegistryName("xp_talisman"));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(xpTalisman, new Object[]{"GG ", " R ", " GG", Character.valueOf('G'), "ingotGold", Character.valueOf('R'), "dustRedstone"}));
            this.initTalismanProperty("logWood", 2);
            this.initTalismanProperty(Items.field_151044_h, 2);
            this.initTalismanProperty("ingotBrick", 4);
            this.initTalismanProperty(Items.field_151122_aG, 4);
            this.initTalismanProperty("oreIron", 8);
            this.initTalismanProperty("gemLapis", 8);
            this.initTalismanProperty("dustRedstone", 8);
            this.initTalismanProperty(Items.field_151025_P, 10);
            this.initTalismanProperty(Items.field_151127_ba, 10);
            this.initTalismanProperty(Item.func_150898_a((Block)Blocks.field_150423_aK), 10);
            this.initTalismanProperty(Items.field_151157_am, 12);
            this.initTalismanProperty(Items.field_151083_be, 12);
            this.initTalismanProperty(Items.field_151077_bg, 12);
            this.initTalismanProperty(Items.field_179566_aV, 12);
            this.initTalismanProperty(Items.field_179557_bn, 12);
            this.initTalismanProperty(Items.field_179559_bp, 12);
            this.initTalismanProperty("ingotIron", 16);
            this.initTalismanProperty("oreGold", 20);
            this.initTalismanProperty("ingotGold", 24);
            this.initTalismanProperty("gemDiamond", 40);
        }
        if (bookEnabled) {
            respecBook = new ItemRespecBook().func_77655_b("respecBook").func_77637_a(CreativeTabs.field_78040_i);
            GameRegistry.register((IForgeRegistryEntry)respecBook.setRegistryName("respec_book"));
            ItemStack output = new ItemStack(respecBook);
            if (config.getBoolean("unlearning Book Reset Class", "Cheats", false, "Should unlearning book also remove class")) {
                output.func_77964_b(1);
            }
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, new Object[]{"OEO", "DBD", "ODO", Character.valueOf('O'), "obsidian", Character.valueOf('D'), "dye", Character.valueOf('E'), "enderpearl", Character.valueOf('B'), Items.field_151122_aG}));
        }
        if (legacyRecipes) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151080_bb, 4), (Object[])new Object[]{Blocks.field_150423_aK});
            GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150351_n, 4), (Object[])new Object[]{"##", "##", Character.valueOf('#'), Items.field_151145_ak});
        }
        if (event.getSourceFile().getName().endsWith(".jar")) {
            proxy.tryUseMUD();
        }
        MinecraftForge.EVENT_BUS.register((Object)FMLEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEventHandler());
    }

    private void initTalismanProperty(Object item, int value) {
        towItems.put(item, value);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(xpTalisman, new Object[]{xpTalisman, item}));
    }

    private void initClientProperties() {
        this.clientProperties = new Property[]{config.get("HUD", "allow HUD", allowHUD, "If anything should be rendered on screen at all.").setRequiresMcRestart(true), config.get("HUD", "render HUD on Top Left", renderTopLeft, "Should the player class be displayed in the top left corner."), config.get("HUD", "render HUD on Exp Bar", renderExpBar, "Should available skill points be displayed on the experience bar."), config.get("FOV", "speed based", changeFOV, "Should FOV change based on player speed from athletics / sneak skills.")};
        allowHUD = this.clientProperties[0].getBoolean();
        renderTopLeft = this.clientProperties[1].getBoolean();
        renderExpBar = this.clientProperties[2].getBoolean();
        changeFOV = this.clientProperties[3].getBoolean();
    }

    private void initServerProperties() {
        String cat = "Cheats";
        String limitedBonus = "This is a bonus related to a few classes";
        this.serverProperties = new Property[]{config.get(cat, "Max points per skill", ClassBonus.getMaxSkillPoints(), "Minimum is 1"), config.get(cat, "Bonus points for classes", ClassBonus.getBonusPoints(), "Points given when choosing a class, allocated automatically.\n Minimum is 0, Maximum is max points per skill times 2"), config.get(cat, "Xp gain per level", PlayerEventHandler.xpPerLevel, "Minimum is 0"), config.get(cat, "Skill points lost on death", (int)PlayerEventHandler.resetSkillOnDeath * 100, "How much skill points are lost on death, in percent.").setMinValue(0).setMaxValue(100), config.get(cat, "Use old speed for dirt and gravel digging", PlayerEventHandler.oldSpeedDigging), config.get(cat, "Use old speed for redstone breaking", PlayerEventHandler.oldSpeedRedstone, "Makes the redstone ore mining efficient"), config.get(cat, "Reset player class on death", PlayerEventHandler.resetClassOnDeath, "Do the player lose the class he choose on death ?"), config.get(cat, "Prevent duplicated ores placing", PlayerEventHandler.noPlaceDuplicate, "Some skill duplicate ores, this prevent infinite duplication by replacing"), config.get(cat, "Add Bonus XP on Craft", bonusCraftingXP, limitedBonus), config.get(cat, "Add Bonus XP on Mining", bonusMiningXP, limitedBonus), config.get(cat, "Add XP on Crafting some items", true, "This is a global bonus, limited to a few craftable items"), config.get(cat, "Add XP on Mining some ore", oreMiningXP, "This is a global bonus, limited to a few ores"), config.get(cat, "Add Bonus XP on Fighting", bonusFightingXP, limitedBonus), config.get(cat, "Furnace ejects smelting bonus", LevelUpAPI.furnaceEjection, "Disabling this will cause doubled furnace items to be added to the result slot instead of being ejected"), config.get(cat, "Ore blocks harvested cannot be placed", oreNoPlace, "Disabling this will stop ore blocks from having a No Place tag added if not duplicated.")};
    }

    public void useServerProperties() {
        ClassBonus.setSkillMax(this.serverProperties[0].getInt());
        ClassBonus.setBonusPoints(this.serverProperties[1].getInt());
        double opt = this.serverProperties[2].getDouble();
        if (opt >= 0.0) {
            PlayerEventHandler.xpPerLevel = opt <= (double)ClassBonus.getMaxSkillPoints() ? opt : (double)ClassBonus.getMaxSkillPoints();
        }
        PlayerEventHandler.resetSkillOnDeath = (float)this.serverProperties[3].getInt() / 100.0f;
        PlayerEventHandler.oldSpeedDigging = this.serverProperties[4].getBoolean();
        PlayerEventHandler.oldSpeedRedstone = this.serverProperties[5].getBoolean();
        PlayerEventHandler.resetClassOnDeath = this.serverProperties[6].getBoolean();
        PlayerEventHandler.noPlaceDuplicate = this.serverProperties[7].getBoolean();
        bonusCraftingXP = this.serverProperties[8].getBoolean();
        bonusMiningXP = this.serverProperties[9].getBoolean();
        oreMiningXP = this.serverProperties[11].getBoolean();
        bonusFightingXP = this.serverProperties[12].getBoolean();
        LevelUpAPI.furnaceEjection = this.serverProperties[13].getBoolean();
        oreNoPlace = this.serverProperties[14].getBoolean();
        if (this.serverProperties[10].getBoolean()) {
            List<Item> ingrTier1 = Arrays.asList(Items.field_151055_y, Items.field_151116_aA, Item.func_150898_a((Block)Blocks.field_150348_b));
            List<Item> ingrTier2 = Arrays.asList(Items.field_151042_j, Items.field_151043_k, Items.field_151121_aF, Items.field_151123_aH);
            List<Item> ingrTier3 = Arrays.asList(Items.field_151137_ax, Items.field_151114_aO, Items.field_151079_bi);
            List<Item> ingrTier4 = Arrays.asList(Items.field_151045_i);
            tiers = new List[]{ingrTier1, ingrTier2, ingrTier3, ingrTier4};
        }
    }

    public Property[] getServerProperties() {
        return this.serverProperties;
    }

    public boolean[] getClientProperties() {
        boolean[] result = new boolean[this.clientProperties.length];
        for (int i = 0; i < this.clientProperties.length; ++i) {
            result[i] = this.clientProperties[i].getBoolean();
        }
        return result;
    }

    public void refreshValues(boolean[] values) {
        if (values.length == this.clientProperties.length) {
            allowHUD = values[0];
            renderTopLeft = values[1];
            renderExpBar = values[2];
            changeFOV = values[3];
            for (int i = 0; i < values.length; ++i) {
                this.clientProperties[i].set(values[i]);
            }
            config.save();
        }
    }

    public static void giveBonusFightingXP(EntityPlayer player) {
        byte pClass;
        if (bonusFightingXP && ((pClass = PlayerExtendedProperties.getPlayerClass(player)) == 2 || pClass == 5 || pClass == 8 || pClass == 11)) {
            player.func_71023_q(2);
        }
    }

    public static void giveBonusCraftingXP(EntityPlayer player) {
        byte pClass;
        if (bonusCraftingXP && ((pClass = PlayerExtendedProperties.getPlayerClass(player)) == 3 || pClass == 6 || pClass == 9 || pClass == 12)) {
            LevelUp.runBonusCounting(player, 1);
        }
    }

    public static void giveBonusMiningXP(EntityPlayer player) {
        byte pClass;
        if (bonusMiningXP && ((pClass = PlayerExtendedProperties.getPlayerClass(player)) == 1 || pClass == 4 || pClass == 7 || pClass == 10)) {
            LevelUp.runBonusCounting(player, 0);
        }
    }

    private static void runBonusCounting(EntityPlayer player, int type) {
        Map<String, int[]> counters = PlayerExtendedProperties.getCounterMap(player);
        int[] bonus = counters.get(PlayerExtendedProperties.counters[2]);
        if (bonus == null || bonus.length == 0) {
            bonus = new int[]{0, 0, 0};
        }
        if (bonus[type] < 4) {
            int n = type;
            bonus[n] = bonus[n] + 1;
        } else {
            bonus[type] = 0;
            player.func_71023_q(2);
        }
        counters.put(PlayerExtendedProperties.counters[2], bonus);
    }

    public static void giveCraftingXP(EntityPlayer player, ItemStack itemstack) {
        if (tiers != null) {
            for (int i = 0; i < tiers.length; ++i) {
                if (!tiers[i].contains(itemstack.func_77973_b()) || LevelUp.isUncraftable(itemstack)) continue;
                LevelUp.incrementCraftCounter(player, i);
            }
        }
    }

    private static void incrementCraftCounter(EntityPlayer player, int i) {
        Map<String, int[]> counters = PlayerExtendedProperties.getCounterMap(player);
        int[] craft = counters.get(PlayerExtendedProperties.counters[1]);
        if (craft.length <= i) {
            int[] craftnew = new int[i + 1];
            System.arraycopy(craft, 0, craftnew, 0, craft.length);
            counters.put(PlayerExtendedProperties.counters[1], craftnew);
            craft = craftnew;
        }
        int n = i;
        craft[n] = craft[n] + 1;
        boolean flag = false;
        for (float f = (float)Math.pow(2.0, 3 - i); f <= (float)craft[i]; f += 0.5f) {
            player.func_71023_q(1);
            flag = true;
        }
        if (flag) {
            craft[i] = 0;
        }
        counters.put(PlayerExtendedProperties.counters[1], craft);
    }

    public static void incrementOreCounter(EntityPlayer player, int i) {
        if (oreMiningXP) {
            Map<String, int[]> counters = PlayerExtendedProperties.getCounterMap(player);
            int[] ore = counters.get(PlayerExtendedProperties.counters[0]);
            if (ore.length <= i) {
                int[] orenew = new int[i + 1];
                System.arraycopy(ore, 0, orenew, 0, ore.length);
                counters.put(PlayerExtendedProperties.counters[0], orenew);
                ore = orenew;
            }
            int n = i;
            ore[n] = ore[n] + 1;
            boolean flag = false;
            for (float f = (float)Math.pow(2.0, 3 - i) / 2.0f; f <= (float)ore[i]; f += 0.5f) {
                player.func_71023_q(1);
                flag = true;
            }
            if (flag) {
                ore[i] = 0;
            }
            counters.put(PlayerExtendedProperties.counters[0], ore);
        }
        LevelUp.giveBonusMiningXP(player);
    }

    public static boolean isTalismanRecipe(IInventory iinventory) {
        if (xpTalisman != null) {
            for (int i = 0; i < iinventory.func_70302_i_(); ++i) {
                if (iinventory.func_70301_a(i) == null || iinventory.func_70301_a(i).func_77973_b() != xpTalisman) continue;
                return true;
            }
        }
        return false;
    }

    public static void takenFromCrafting(EntityPlayer player, ItemStack itemstack, IInventory iinventory) {
        if (LevelUp.isTalismanRecipe(iinventory)) {
            for (int i = 0; i < iinventory.func_70302_i_(); ++i) {
                ItemStack itemstack1 = iinventory.func_70301_a(i);
                if (itemstack1 == null) continue;
                String oreDict = LevelUp.containsOreDictEntry(itemstack1);
                if (oreDict != null) {
                    player.func_71023_q((int)Math.floor((double)(itemstack1.field_77994_a * towItems.get(LevelUp.containsOreDictEntry(itemstack1))) / 4.0));
                    iinventory.func_70301_a((int)i).field_77994_a = 0;
                    continue;
                }
                if (!towItems.containsKey(itemstack1.func_77973_b())) continue;
                player.func_71023_q((int)Math.floor((double)(itemstack1.field_77994_a * towItems.get(itemstack1.func_77973_b())) / 4.0));
                iinventory.func_70301_a((int)i).field_77994_a = 0;
            }
        } else {
            for (int j = 0; j < iinventory.func_70302_i_(); ++j) {
                ItemStack itemstack2 = iinventory.func_70301_a(j);
                if (itemstack2 == null || LevelUp.isUncraftable(itemstack)) continue;
                LevelUp.giveCraftingXP(player, itemstack2);
                LevelUp.giveBonusCraftingXP(player);
            }
        }
    }

    private static String containsOreDictEntry(ItemStack stack) {
        String[] toCheck;
        for (String entry : toCheck = new String[]{"logWood", "ingotIron", "ingotGold", "ingotBrick", "gemDiamond", "oreIron", "oreGold", "dustRedstone", "gemLapis"}) {
            if (!LevelUp.oreDictMatches(stack, OreDictionary.getOres((String)entry))) continue;
            return entry;
        }
        return null;
    }

    private static boolean oreDictMatches(ItemStack stack, List<ItemStack> oreDict) {
        for (ItemStack ore : oreDict) {
            if (ore.func_77952_i() == Short.MAX_VALUE && ore.func_77973_b() == stack.func_77973_b()) {
                return true;
            }
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)ore)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUncraftable(ItemStack stack) {
        return CraftingBlacklist.contains(stack);
    }

    private static boolean isUncraftable(Item item) {
        return CraftingBlacklist.contains(item);
    }

    static {
        allowHUD = true;
        renderTopLeft = true;
        renderExpBar = true;
        changeFOV = true;
        oreNoPlace = true;
        bonusMiningXP = true;
        bonusCraftingXP = true;
        bonusFightingXP = true;
        oreMiningXP = true;
    }
}

