/*
 * Decompiled with CFR 0.152.
 */
package levelup.event;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import levelup.ClassBonus;
import levelup.LevelUp;
import levelup.SkillPacketHandler;
import levelup.api.IProcessor;
import levelup.capabilities.LevelUpCapability;
import levelup.event.PlayerEventHandler;
import levelup.player.PlayerExtendedProperties;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;

public final class FMLEventHandler {
    private static final UUID speedID = UUID.fromString("4f7637c8-6106-4050-96cb-e47f83bfa415");
    private static final UUID sneakID = UUID.fromString("a4dc0b04-f78a-43f6-8805-5ebfbab10b18");
    public static final FMLEventHandler INSTANCE = new FMLEventHandler();
    private List<IPlantable> blackListedCrops;

    private FMLEventHandler() {
    }

    @SubscribeEvent
    public void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            AttributeModifier mod;
            double diff;
            EntityPlayer player = event.player;
            if (player != null && !player.field_70170_p.field_72995_K) {
                ArrayList<TileEntity> tile = new ArrayList<TileEntity>();
                BlockPos checkPos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                for (BlockPos pos : BlockPos.func_177980_a((BlockPos)checkPos.func_177982_a(-4, -2, -4), (BlockPos)checkPos.func_177982_a(4, 3, 4))) {
                    TileEntity entity;
                    if (pos.func_177956_o() <= 0 || event.player.field_70170_p.func_175625_s(pos) == null || !(entity = event.player.field_70170_p.func_175625_s(pos)).hasCapability(LevelUpCapability.MACHINE_PROCESSING, EnumFacing.DOWN)) continue;
                    tile.add(entity);
                }
                if (!tile.isEmpty()) {
                    for (TileEntity entity : tile) {
                        IProcessor process = (IProcessor)entity.getCapability(LevelUpCapability.MACHINE_PROCESSING, EnumFacing.DOWN);
                        process.extraProcessing(player);
                    }
                }
            }
            if (PlayerExtendedProperties.getPlayerClass(player) != 0 && (diff = PlayerEventHandler.xpPerLevel * (double)(player.field_71068_ca - 4) + (double)ClassBonus.getBonusPoints() - (double)PlayerExtendedProperties.from(player).getSkillPoints()) >= 1.0) {
                PlayerExtendedProperties.from(player).addToSkill("XP", (int)Math.floor(diff));
            }
            int skill = FMLEventHandler.getSkill(player, 9);
            if (!player.field_70170_p.field_72995_K && skill != 0 && player.func_70681_au().nextFloat() <= (float)skill / 2500.0f) {
                this.growCropsAround(player.field_70170_p, skill / 4, player);
            }
            IAttributeInstance atinst = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
            skill = FMLEventHandler.getSkill(player, 6);
            if (skill != 0) {
                mod = new AttributeModifier(speedID, "SprintingSkillSpeed", (double)((float)skill / 100.0f), 2);
                if (player.func_70051_ag()) {
                    if (atinst.func_111127_a(speedID) == null) {
                        atinst.func_111121_a(mod);
                    }
                } else if (atinst.func_111127_a(speedID) != null) {
                    atinst.func_111124_b(mod);
                }
                if (player.field_70143_R > 0.0f) {
                    player.field_70143_R *= 1.0f - (float)(skill / 5) / 100.0f;
                }
            }
            if ((skill = FMLEventHandler.getSkill(player, 8)) != 0) {
                mod = new AttributeModifier(sneakID, "SneakingSkillSpeed", (double)((float)(2 * skill) / 100.0f), 2);
                if (player.func_70093_af()) {
                    if (atinst.func_111127_a(sneakID) == null) {
                        atinst.func_111121_a(mod);
                    }
                } else if (atinst.func_111127_a(sneakID) != null) {
                    atinst.func_111124_b(mod);
                }
            }
        }
    }

    private void growCropsAround(World world, int range, EntityPlayer player) {
        int posX = (int)player.field_70165_t;
        int posY = (int)player.field_70163_u;
        int posZ = (int)player.field_70161_v;
        int dist = range / 2 + 2;
        for (Object o : BlockPos.func_177980_a((BlockPos)new BlockPos(posX - dist, posY - dist, posZ - dist), (BlockPos)new BlockPos(posX + dist + 1, posY + dist + 1, posZ + dist + 1))) {
            BlockPos pos = (BlockPos)o;
            Block block = world.func_180495_p(pos).func_177230_c();
            if (!(block instanceof IPlantable) || this.blackListedCrops.contains(block)) continue;
            world.func_175684_a(pos, block, block.func_149738_a(world));
        }
    }

    public void addCropsToBlackList(List<String> blackList) {
        if (this.blackListedCrops == null) {
            this.blackListedCrops = new ArrayList<IPlantable>(blackList.size());
        }
        for (String txt : blackList) {
            IForgeRegistryEntry crop = GameData.getBlockRegistry().getObject(new ResourceLocation(txt));
            if (!(crop instanceof IPlantable)) continue;
            this.blackListedCrops.add((IPlantable)crop);
        }
    }

    public static int getSkill(EntityPlayer player, int id) {
        return PlayerExtendedProperties.getSkillFromIndex(player, id);
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        LevelUp.takenFromCrafting(event.player, event.crafting, event.craftMatrix);
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.loadPlayer(event.player);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.loadPlayer(event.player);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            this.loadPlayer(event.player);
            LevelUp.configChannel.sendTo(SkillPacketHandler.getConfigPacket(LevelUp.instance.getServerProperties()), (EntityPlayerMP)event.player);
        }
    }

    public void loadPlayer(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            byte cl = PlayerExtendedProperties.getPlayerClass(player);
            int[] data = PlayerExtendedProperties.from(player).getPlayerData(false);
            LevelUp.initChannel.sendTo(SkillPacketHandler.getPacket(Side.CLIENT, 0, cl, data), (EntityPlayerMP)player);
        }
    }
}

