/*
 * Decompiled with CFR 0.152.
 */
package levelup.event;

import levelup.event.BowEventHandler;
import levelup.player.PlayerExtendedProperties;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemShield;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class FightEventHandler {
    public static final FightEventHandler INSTANCE = new FightEventHandler();

    private FightEventHandler() {
    }

    @SubscribeEvent
    public void onHurting(LivingHurtEvent event) {
        int j;
        DamageSource damagesource = event.getSource();
        float i = event.getAmount();
        if (damagesource.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)damagesource.func_76346_g();
            if (damagesource instanceof EntityDamageSourceIndirect) {
                if (!damagesource.field_76373_n.equals("arrow")) {
                    i *= 1.0f + (float)BowEventHandler.getArcherSkill(entityplayer) / 100.0f;
                }
                if (FightEventHandler.getDistance(event.getEntityLiving(), (EntityLivingBase)entityplayer) < 256.0f && entityplayer.func_70093_af() && !FightEventHandler.canSeePlayer(event.getEntityLiving()) && !FightEventHandler.entityIsFacing(event.getEntityLiving(), (EntityLivingBase)entityplayer)) {
                    i *= 1.5f;
                    entityplayer.func_146105_b((ITextComponent)new TextComponentTranslation("sneak.attack", new Object[]{1.5}));
                }
            } else {
                if (entityplayer.func_184614_ca() != null) {
                    j = this.getSwordSkill(entityplayer);
                    if (entityplayer.func_70681_au().nextDouble() <= (double)j / 200.0) {
                        i *= 2.0f;
                    }
                    i *= 1.0f + (float)(j / 5) / 20.0f;
                }
                if (entityplayer.func_70093_af() && !FightEventHandler.canSeePlayer(event.getEntityLiving()) && !FightEventHandler.entityIsFacing(event.getEntityLiving(), (EntityLivingBase)entityplayer)) {
                    i *= 2.0f;
                    entityplayer.func_146105_b((ITextComponent)new TextComponentTranslation("sneak.attack", new Object[]{2}));
                }
            }
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            j = this.getDefenseSkill(player);
            if (!damagesource.func_76363_c()) {
                i *= 1.0f - (float)(j / 5) / 20.0f;
            }
            if (this.isBlocking(player) && player.func_70681_au().nextFloat() < (float)j / 100.0f) {
                i *= 0.0f;
            }
        }
        event.setAmount(i);
    }

    private boolean isBlocking(EntityPlayer player) {
        return player.func_184587_cr() && player.func_184607_cu() != null && player.func_184607_cu().func_77973_b() instanceof ItemShield;
    }

    @SubscribeEvent
    public void onTargetSet(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof EntityPlayer && event.getEntityLiving() instanceof EntityMob && event.getTarget().func_70093_af() && !FightEventHandler.entityHasVisionOf(event.getEntityLiving(), (EntityPlayer)event.getTarget()) && event.getEntityLiving().func_142015_aE() != event.getEntityLiving().field_70173_aa) {
            ((EntityMob)event.getEntityLiving()).func_70624_b(null);
        }
    }

    private int getDefenseSkill(EntityPlayer player) {
        return PlayerExtendedProperties.getSkillFromIndex(player, 2);
    }

    private int getSwordSkill(EntityPlayer player) {
        return PlayerExtendedProperties.getSkillFromIndex(player, 1);
    }

    public static boolean canSeePlayer(EntityLivingBase entityLiving) {
        EntityPlayer entityplayer = entityLiving.field_70170_p.func_72890_a((Entity)entityLiving, 16.0);
        return entityplayer != null && entityLiving.func_70685_l((Entity)entityplayer) && (!entityplayer.func_70093_af() || FightEventHandler.entityHasVisionOf(entityLiving, entityplayer));
    }

    public static float getDistance(EntityLivingBase entityLiving, EntityLivingBase entityliving1) {
        return MathHelper.func_76124_d((double)((entityliving1.field_70165_t - entityLiving.field_70165_t) * (entityliving1.field_70165_t - entityLiving.field_70165_t) + (entityliving1.field_70161_v - entityLiving.field_70161_v) * (entityliving1.field_70161_v - entityLiving.field_70161_v)));
    }

    public static float getPointDistance(double d, double d1, double d2, double d3) {
        return MathHelper.func_76124_d((double)((d2 - d) * (d2 - d) + (d3 - d1) * (d3 - d1)));
    }

    public static boolean compareAngles(float f, float f1, float f2) {
        if (MathHelper.func_76135_e((float)(f - f1)) < f2) {
            return true;
        }
        if (f + f2 >= 360.0f && f + f2 - 360.0f > f1) {
            return true;
        }
        return f1 + f2 >= 360.0f && f1 + f2 - 360.0f > f;
    }

    public static boolean entityHasVisionOf(EntityLivingBase entityLiving, EntityPlayer player) {
        if (entityLiving == null || player == null) {
            return false;
        }
        if (FightEventHandler.getDistance(entityLiving, (EntityLivingBase)player) > 256.0f - (float)(PlayerExtendedProperties.from(player).getSkillFromIndex("Sneaking") / 5) * 12.8f) {
            return false;
        }
        return entityLiving.func_70685_l((Entity)player) && FightEventHandler.entityIsFacing((EntityLivingBase)player, entityLiving);
    }

    public static boolean entityIsFacing(EntityLivingBase entityLiving, EntityLivingBase entityliving1) {
        if (entityLiving == null || entityliving1 == null) {
            return false;
        }
        float f = -((float)(entityliving1.field_70165_t - entityLiving.field_70165_t));
        float f1 = (float)(entityliving1.field_70161_v - entityLiving.field_70161_v);
        float f2 = entityLiving.field_70177_z;
        if (f2 < 0.0f) {
            float f3 = ((float)MathHelper.func_76141_d((float)(MathHelper.func_76135_e((float)f2) / 360.0f)) + 1.0f) * 360.0f;
            f2 = f3 + f2;
        } else {
            while (f2 > 360.0f) {
                f2 -= 360.0f;
            }
        }
        float f4 = (float)(Math.atan2(f, f1) * 180.0 / Math.PI);
        if (f < 0.0f) {
            f4 = 360.0f + f4;
        }
        return FightEventHandler.compareAngles(f2, f4, 22.5f);
    }
}

