/*
 * Decompiled with CFR 0.152.
 */
package levelup.minetweaker;

import java.util.List;
import levelup.minetweaker.utils.BaseListAddition;
import levelup.minetweaker.utils.LogHelper;
import levelup.util.CraftingBlacklist;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.levelup.CraftBlacklist")
public class CraftBlacklist {
    private static final List<ItemStack> blacklist = CraftingBlacklist.getBlacklist();

    @ZenMethod
    public static void add(IIngredient input) {
        if (input instanceof IOreDictEntry) {
            for (ItemStack stack : OreDictionary.getOres((String)((IOreDictEntry)input).getName())) {
                MineTweakerAPI.apply((IUndoableAction)new Add(stack.func_77946_l()));
            }
        } else if (input instanceof IItemStack) {
            ItemStack stack = CraftBlacklist.toStack((IItemStack)input);
            MineTweakerAPI.apply((IUndoableAction)new Add(stack.func_77946_l()));
        }
    }

    public static ItemStack toStack(IItemStack iStack) {
        if (iStack == null) {
            return null;
        }
        Object internal = iStack.getInternal();
        if (!(internal instanceof ItemStack)) {
            LogHelper.logError("Not a valid item stack: " + iStack);
        }
        return (ItemStack)internal;
    }

    public static class Add
    extends BaseListAddition<ItemStack> {
        protected Add(ItemStack stack) {
            super("crafting blacklist", blacklist);
            this.recipes.add(stack.func_77946_l());
        }

        @Override
        protected String getRecipeInfo(ItemStack stack) {
            return LogHelper.getStackDescription(stack);
        }
    }
}

