/*
 * Decompiled with CFR 0.152.
 */
package levelup.minetweaker.utils;

import java.util.List;
import levelup.minetweaker.utils.BaseListModification;
import levelup.minetweaker.utils.LogHelper;

public abstract class BaseListAddition<T>
extends BaseListModification<T> {
    protected BaseListAddition(String name, List<T> list) {
        super(name, list);
    }

    protected BaseListAddition(String name, List<T> list, List<T> recipies) {
        this(name, list);
        if (this.recipes != null) {
            this.recipes.addAll(recipies);
        }
    }

    public void apply() {
        if (this.recipes.isEmpty()) {
            return;
        }
        for (Object recipe : this.recipes) {
            if (recipe != null) {
                if (this.list.add(recipe)) {
                    this.successful.add(recipe);
                    continue;
                }
                LogHelper.logError(String.format("Error adding %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                continue;
            }
            LogHelper.logError(String.format("Error adding %s Recipe: null object", this.name));
        }
    }

    public void undo() {
        if (this.successful.isEmpty()) {
            return;
        }
        for (Object recipe : this.successful) {
            if (recipe != null) {
                if (this.list.remove(recipe)) continue;
                LogHelper.logError(String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                continue;
            }
            LogHelper.logError(String.format("Error removing %s Recipe: null object", this.name));
        }
    }

    @Override
    public String describe() {
        return String.format("[LevelUp!] Adding %d %s blacklist(s) for %s", this.recipes.size(), this.name, this.getRecipeInfo());
    }

    @Override
    public String describeUndo() {
        return String.format("[LevelUp!] Removing %d %s blacklist(s) for %s", this.recipes.size(), this.name, this.getRecipeInfo());
    }
}

