/*
 * Decompiled with CFR 0.152.
 */
package levelup.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class SmeltingBlacklist {
    private static List<ItemStack> blacklist = new ArrayList<ItemStack>();

    public static void addItem(Block block) {
        blacklist.add(new ItemStack(block, 1, Short.MAX_VALUE));
    }

    public static void addItem(Item item) {
        blacklist.add(new ItemStack(item, 1, Short.MAX_VALUE));
    }

    public static boolean addItem(ItemStack stack) {
        return blacklist.add(stack.func_77946_l());
    }

    public static void addOres(String name) {
        for (ItemStack stack : OreDictionary.getOres((String)name)) {
            SmeltingBlacklist.addItem(stack);
        }
    }

    public static void add(Object obj) {
        if (obj instanceof ItemStack) {
            SmeltingBlacklist.addItem((ItemStack)obj);
        } else if (obj instanceof String) {
            SmeltingBlacklist.addOres((String)obj);
        }
    }

    public static boolean contains(ItemStack stack) {
        boolean match = false;
        boolean wild = stack.func_77960_j() == Short.MAX_VALUE;
        for (ItemStack black : blacklist) {
            if (match) break;
            if (wild) {
                match = black.func_77973_b() == stack.func_77973_b();
                continue;
            }
            match = ItemStack.func_179545_c((ItemStack)black, (ItemStack)stack) || black.func_77960_j() == Short.MAX_VALUE && stack.func_77973_b() == black.func_77973_b();
        }
        return match;
    }

    public static boolean contains(Item item) {
        return SmeltingBlacklist.contains(new ItemStack(item, 1, Short.MAX_VALUE));
    }

    public static boolean contains(Block block) {
        return SmeltingBlacklist.contains(new ItemStack(block, 1, Short.MAX_VALUE));
    }

    public static boolean remove(ItemStack stack) {
        if (SmeltingBlacklist.contains(stack)) {
            return blacklist.remove(stack);
        }
        return false;
    }

    public static void removeOres(String name) {
        for (ItemStack stack : OreDictionary.getOres((String)name)) {
            SmeltingBlacklist.remove(stack);
        }
    }

    public static List<ItemStack> getBlacklist() {
        return blacklist;
    }
}

