/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.gui;

import com.google.common.base.Preconditions;
import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.client.gui.GuiButtonTextToggle;
import ichttt.mods.mcpaint.client.gui.GuiHollowButton;
import ichttt.mods.mcpaint.client.gui.drawutil.EnumDrawType;
import ichttt.mods.mcpaint.client.gui.drawutil.EnumPaintColor;
import ichttt.mods.mcpaint.client.gui.drawutil.PictureState;
import ichttt.mods.mcpaint.client.render.PictureRenderer;
import ichttt.mods.mcpaint.common.MCPaintUtil;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import ichttt.mods.mcpaint.networking.MessageDrawAbort;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiDraw
extends GuiScreen
implements GuiPageButtonList.GuiResponder,
GuiSlider.FormatHelper {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("mcpaint", "textures/gui/setup.png");
    public static final int ZERO_ALPHA = new Color(255, 255, 255, 0).getRGB();
    private static final int PICTURE_START_LEFT = 6;
    private static final int PICTURE_START_TOP = 9;
    private static final int xSize = 176;
    private static final int ySize = 166;
    private static final int toolXSize = 80;
    private static final int toolYSize = 95;
    private static final int sizeXSize = 80;
    private static final int sizeYSize = 34;
    private final BlockPos pos;
    private final EnumFacing facing;
    private final IBlockState state;
    private final LinkedList<PictureState> statesForUndo = new LinkedList();
    private final LinkedList<PictureState> statesForRedo = new LinkedList();
    private final boolean hadPaint;
    private Color color = Color.BLACK;
    private PictureState paintingState;
    private PictureState currentState;
    private int guiLeft;
    private int guiTop;
    private boolean clickStartedInPicture = false;
    private final List<GuiButtonTextToggle> textToggleList = new ArrayList<GuiButtonTextToggle>();
    private EnumDrawType activeDrawType;
    private int toolSize = 1;
    private GuiButton undo;
    private GuiButton redo;
    private GuiButton lessSize;
    private GuiButton moreSize;
    private GuiSlider redSlider;
    private GuiSlider blueSlider;
    private GuiSlider greenSlider;
    private GuiSlider alphaSlider;
    private boolean hasSizeWindow;
    private boolean noRevert = false;

    public GuiDraw(IPaintable canvas, List<IPaintable> prevImages, BlockPos pos, EnumFacing facing, IBlockState state) {
        Objects.requireNonNull(canvas, "Canvas is null");
        Preconditions.checkArgument((boolean)canvas.hasPaintData(), (Object)"No data in canvas");
        this.pos = pos;
        this.facing = facing;
        this.state = state;
        this.currentState = new PictureState(canvas);
        for (IPaintable paint : prevImages) {
            this.statesForUndo.add(new PictureState(paint));
        }
        this.hadPaint = true;
    }

    protected GuiDraw(byte scaleFactor, BlockPos pos, EnumFacing facing, IBlockState state) {
        int[][] picture;
        this.pos = Objects.requireNonNull(pos);
        this.facing = facing;
        this.state = state;
        for (int[] tileArray : picture = new int[128 / scaleFactor][128 / scaleFactor]) {
            Arrays.fill(tileArray, ZERO_ALPHA);
        }
        this.currentState = new PictureState(picture, scaleFactor);
        this.hadPaint = false;
    }

    public void func_73866_w_() {
        this.hasSizeWindow = false;
        this.textToggleList.clear();
        this.guiLeft = (this.field_146294_l - 176) / 2;
        this.guiTop = (this.field_146295_m - 166) / 2;
        GuiButton saveImage = new GuiButton(-12, this.guiLeft + 176, this.guiTop + 96, 80, 20, "Export");
        GuiButton rotateRight = new GuiButton(-11, this.guiLeft - 80 + 2 + 39, this.guiTop + 5 + 22 + 22 + 22, 36, 20, I18n.func_135052_a((String)"mcpaint.gui.rright", (Object[])new Object[0]));
        GuiButton rotateLeft = new GuiButton(-10, this.guiLeft - 80 + 3, this.guiTop + 5 + 22 + 22 + 22, 36, 20, I18n.func_135052_a((String)"mcpaint.gui.rleft", (Object[])new Object[0]));
        this.redo = new GuiButton(-9, this.guiLeft - 80 + 2 + 39, this.guiTop + 5 + 22 + 22, 36, 20, I18n.func_135052_a((String)"mcpaint.gui.redo", (Object[])new Object[0]));
        this.undo = new GuiButton(-8, this.guiLeft - 80 + 3, this.guiTop + 5 + 22 + 22, 36, 20, I18n.func_135052_a((String)"mcpaint.gui.undo", (Object[])new Object[0]));
        GuiButtonTextToggle pickColor = new GuiButtonTextToggle(-7, this.guiLeft - 80 + 2 + 39, this.guiTop + 5 + 22, 36, 20, EnumDrawType.PICK_COLOR);
        GuiButtonTextToggle erase = new GuiButtonTextToggle(-6, this.guiLeft - 80 + 3, this.guiTop + 5 + 22, 36, 20, EnumDrawType.ERASER);
        GuiButtonTextToggle fill = new GuiButtonTextToggle(-5, this.guiLeft - 80 + 2 + 39, this.guiTop + 5, 36, 20, EnumDrawType.FILL);
        GuiButtonTextToggle pencil = new GuiButtonTextToggle(-4, this.guiLeft - 80 + 3, this.guiTop + 5, 36, 20, EnumDrawType.PENCIL);
        this.moreSize = new GuiButton(-3, this.guiLeft - 80 + 3 + 55, this.guiTop + 95 + 5, 20, 20, ">");
        this.lessSize = new GuiButton(-2, this.guiLeft - 80 + 3, this.guiTop + 95 + 5, 20, 20, "<");
        GuiButton done = new GuiButton(-1, this.guiLeft + 88 - 100, this.guiTop + 166 + 20, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        GuiHollowButton black = new GuiHollowButton(0, this.guiLeft + 137, this.guiTop + 9, 16, 16, Color.BLUE.getRGB());
        GuiHollowButton white = new GuiHollowButton(1, this.guiLeft + 137 + 18, this.guiTop + 9, 16, 16, Color.BLUE.getRGB());
        GuiHollowButton gray = new GuiHollowButton(2, this.guiLeft + 137, this.guiTop + 9 + 18, 16, 16, Color.BLUE.getRGB());
        GuiHollowButton red = new GuiHollowButton(3, this.guiLeft + 137 + 18, this.guiTop + 9 + 18, 16, 16, Color.BLUE.getRGB());
        GuiHollowButton orange = new GuiHollowButton(4, this.guiLeft + 137, this.guiTop + 9 + 36, 16, 16, Color.BLUE.getRGB());
        GuiHollowButton yellow = new GuiHollowButton(5, this.guiLeft + 137 + 18, this.guiTop + 9 + 36, 16, 16, Color.BLUE.getRGB());
        GuiHollowButton lime = new GuiHollowButton(6, this.guiLeft + 137, this.guiTop + 9 + 54, 16, 16, Color.BLACK.getRGB());
        GuiHollowButton green = new GuiHollowButton(7, this.guiLeft + 137 + 18, this.guiTop + 9 + 54, 16, 16, Color.BLACK.getRGB());
        GuiHollowButton lightBlue = new GuiHollowButton(8, this.guiLeft + 137, this.guiTop + 9 + 72, 16, 16, Color.BLACK.getRGB());
        GuiHollowButton darkBlue = new GuiHollowButton(9, this.guiLeft + 137 + 18, this.guiTop + 9 + 72, 16, 16, Color.BLACK.getRGB());
        GuiHollowButton purple = new GuiHollowButton(10, this.guiLeft + 137, this.guiTop + 9 + 90, 16, 16, Color.BLACK.getRGB());
        GuiHollowButton pink = new GuiHollowButton(11, this.guiLeft + 137 + 18, this.guiTop + 9 + 90, 16, 16, Color.BLACK.getRGB());
        this.redSlider = new GuiSlider((GuiPageButtonList.GuiResponder)this, 100, this.guiLeft + 176 + 3, this.guiTop + 4, I18n.func_135052_a((String)"mcpaint.gui.red", (Object[])new Object[0]), 0.0f, 255.0f, 0.0f, (GuiSlider.FormatHelper)this);
        this.redSlider.field_146120_f = 74;
        this.greenSlider = new GuiSlider((GuiPageButtonList.GuiResponder)this, 100, this.guiLeft + 176 + 3, this.guiTop + 26, I18n.func_135052_a((String)"mcpaint.gui.green", (Object[])new Object[0]), 0.0f, 255.0f, 0.0f, (GuiSlider.FormatHelper)this);
        this.greenSlider.field_146120_f = 74;
        this.blueSlider = new GuiSlider((GuiPageButtonList.GuiResponder)this, 100, this.guiLeft + 176 + 3, this.guiTop + 48, I18n.func_135052_a((String)"mcpaint.gui.blue", (Object[])new Object[0]), 0.0f, 255.0f, 0.0f, (GuiSlider.FormatHelper)this);
        this.blueSlider.field_146120_f = 74;
        this.alphaSlider = new GuiSlider((GuiPageButtonList.GuiResponder)this, 100, this.guiLeft + 176 + 3, this.guiTop + 70, I18n.func_135052_a((String)"mcpaint.gui.alpha", (Object[])new Object[0]), 0.0f, 255.0f, 0.0f, (GuiSlider.FormatHelper)this);
        this.alphaSlider.field_146120_f = 74;
        this.func_189646_b(saveImage);
        this.func_189646_b(rotateRight);
        this.func_189646_b(rotateLeft);
        this.func_189646_b(this.redo);
        this.func_189646_b(this.undo);
        this.func_189646_b(pickColor);
        this.func_189646_b(erase);
        this.func_189646_b(fill);
        this.func_189646_b(pencil);
        this.func_189646_b(done);
        this.func_189646_b(black);
        this.func_189646_b(white);
        this.func_189646_b(gray);
        this.func_189646_b(red);
        this.func_189646_b(orange);
        this.func_189646_b(yellow);
        this.func_189646_b(lime);
        this.func_189646_b(green);
        this.func_189646_b(lightBlue);
        this.func_189646_b(darkBlue);
        this.func_189646_b(purple);
        this.func_189646_b(pink);
        this.func_189646_b((GuiButton)this.redSlider);
        this.func_189646_b((GuiButton)this.greenSlider);
        this.func_189646_b((GuiButton)this.blueSlider);
        this.func_189646_b((GuiButton)this.alphaSlider);
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof GuiButtonTextToggle)) continue;
            this.textToggleList.add((GuiButtonTextToggle)button);
        }
        this.func_146284_a(pencil);
        this.func_146284_a(this.lessSize);
        this.func_146284_a(black);
        this.func_146284_a(this.redo);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int[][] toDraw;
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 176, 166);
        this.func_73729_b(this.guiLeft + 176, this.guiTop, 176, 0, 80, 95);
        this.func_73729_b(this.guiLeft - 80, this.guiTop, 176, 0, 80, 95);
        if (this.hasSizeWindow) {
            this.func_73729_b(this.guiLeft - 80, this.guiTop + 95 + 1, 176, 96, 80, 34);
            this.func_73732_a(this.field_146289_q, this.toolSize + "", this.guiLeft - 80 + 40, this.guiTop + 95 + 11, Color.WHITE.getRGB());
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        List quads = this.field_146297_k.func_175602_ab().func_184389_a(this.state).func_188616_a(this.state, this.facing.func_176734_d(), 0L);
        for (BakedQuad quad : quads) {
            TextureAtlasSprite sprite = quad.func_187508_a();
            GlStateManager.func_179094_E();
            this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            this.field_73735_i = -1.0f;
            if (quad.func_178212_b()) {
                int color = this.field_146297_k.func_184125_al().func_186724_a(this.state, (IBlockAccess)this.field_146297_k.field_71441_e, this.pos, quad.func_178211_c());
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
            }
            this.func_175175_a(this.guiLeft + 6, this.guiTop + 9, sprite, 128, 128);
            this.field_73735_i = 0.0f;
            GlStateManager.func_179121_F();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GuiDraw.func_73734_a((int)(this.guiLeft + 138), (int)(this.guiTop + 125), (int)(this.guiLeft + 138 + 32), (int)(this.guiTop + 125 + 32), (int)this.color.getRGB());
        int offsetMouseX = mouseX - this.guiLeft - 6;
        int offsetMouseY = mouseY - this.guiTop - 9;
        boolean drawSelect = this.isInWindow(offsetMouseX, offsetMouseY) && this.activeDrawType != EnumDrawType.PICK_COLOR;
        int[][] nArray = toDraw = this.paintingState == null ? this.currentState.picture : this.paintingState.picture;
        if (drawSelect) {
            int pixelPosX = offsetMouseX / this.currentState.scaleFactor;
            int pixelPosY = offsetMouseY / this.currentState.scaleFactor;
            toDraw = MCPaintUtil.copyOf(toDraw);
            this.activeDrawType.draw(toDraw, this.color, pixelPosX, pixelPosY, this.toolSize);
        }
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        PictureRenderer.renderInGui(this.guiLeft + 6, this.guiTop + 9, this.currentState.scaleFactor, buffer, toDraw);
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.handleMouse(mouseX, mouseY, mouseButton)) {
            this.clickStartedInPicture = true;
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.clickStartedInPicture && this.handleMouse(mouseX, mouseY, clickedMouseButton)) {
            return;
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.clickStartedInPicture = false;
        if (this.paintingState != null) {
            this.newPictureState(this.paintingState);
            this.paintingState = null;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (Keyboard.isKeyDown((int)29) && keyCode == 44) {
            if (Keyboard.isKeyDown((int)42)) {
                this.redo();
            } else {
                this.undo();
            }
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == -1) {
            if (Arrays.stream(this.currentState.picture).anyMatch(ints -> Arrays.stream(ints).anyMatch(value -> value != ZERO_ALPHA))) {
                this.noRevert = true;
                MCPaintUtil.uploadPictureToServer(this.field_146297_k.field_71441_e.func_175625_s(this.pos), this.facing, this.currentState.scaleFactor, this.currentState.picture, false);
            } else if (this.hadPaint) {
                MCPaintUtil.uploadPictureToServer(this.field_146297_k.field_71441_e.func_175625_s(this.pos), this.facing, this.currentState.scaleFactor, this.currentState.picture, true);
            }
            this.field_146297_k.func_147108_a(null);
        } else if (button.field_146127_k == -2) {
            --this.toolSize;
            this.handleSizeChanged();
        } else if (button.field_146127_k == -3) {
            ++this.toolSize;
            this.handleSizeChanged();
        } else if (button.field_146127_k == -8) {
            this.undo();
        } else if (button.field_146127_k == -9) {
            this.redo();
        } else if (button.field_146127_k == -10) {
            int[][] newData = new int[this.currentState.picture.length][this.currentState.picture[0].length];
            for (int x = 0; x < this.currentState.picture.length; ++x) {
                int[] yData = this.currentState.picture[x];
                for (int y = 0; y < yData.length; ++y) {
                    newData[y][this.currentState.picture.length - x - 1] = yData[y];
                }
            }
            this.newPictureState(new PictureState(newData, this.currentState.scaleFactor));
        } else if (button.field_146127_k == -11) {
            int[][] newData = new int[this.currentState.picture.length][this.currentState.picture[0].length];
            for (int x = 0; x < this.currentState.picture.length; ++x) {
                int[] yData = this.currentState.picture[x];
                for (int y = 0; y < yData.length; ++y) {
                    newData[yData.length - y - 1][x] = yData[y];
                }
            }
            this.newPictureState(new PictureState(newData, this.currentState.scaleFactor));
        } else if (button.field_146127_k == -12) {
            try {
                this.saveImage(true);
            }
            catch (IOException e) {
                MCPaint.LOGGER.error("Could not save image!", (Throwable)e);
                this.field_146297_k.field_71439_g.func_146105_b((ITextComponent)new TextComponentString("Failed to save file!"), true);
                this.field_146297_k.field_71439_g.func_146105_b((ITextComponent)new TextComponentString("Failed to save file!"), false);
            }
        } else if (button.field_146127_k >= 0 && button.field_146127_k < 100) {
            this.color = EnumPaintColor.VALUES[button.field_146127_k].color;
            this.redSlider.func_175218_a((float)this.color.getRed(), false);
            this.blueSlider.func_175218_a((float)this.color.getBlue(), false);
            this.greenSlider.func_175218_a((float)this.color.getGreen(), false);
            this.alphaSlider.func_175218_a((float)this.color.getAlpha(), false);
        } else if (button.field_146127_k < 100) {
            for (GuiButtonTextToggle toggleButton : this.textToggleList) {
                boolean toggled;
                toggleButton.toggled = toggled = toggleButton.field_146127_k == button.field_146127_k;
                if (!toggled) continue;
                this.activeDrawType = toggleButton.type;
                if (this.activeDrawType.hasSizeRegulator && !this.hasSizeWindow) {
                    this.func_189646_b(this.moreSize);
                    this.func_189646_b(this.lessSize);
                } else if (!this.activeDrawType.hasSizeRegulator && this.hasSizeWindow) {
                    this.field_146292_n.remove(this.moreSize);
                    this.field_146292_n.remove(this.lessSize);
                }
                this.hasSizeWindow = this.activeDrawType.hasSizeRegulator;
            }
        }
    }

    public void func_146281_b() {
        if (!this.noRevert) {
            MCPaint.NETWORKING.sendToServer((IMessage)new MessageDrawAbort(this.pos));
        }
    }

    private void newPictureState(PictureState state) {
        if (state.isSame(this.currentState)) {
            return;
        }
        this.statesForRedo.clear();
        this.statesForUndo.add(this.currentState);
        this.currentState = state;
        if (this.statesForUndo.size() > 20) {
            this.statesForUndo.removeFirst();
        }
        this.updateUndoRedoButton();
    }

    private void undo() {
        if (this.statesForUndo.size() > 0) {
            this.statesForRedo.add(this.currentState);
            this.currentState = this.statesForUndo.removeLast();
        }
        this.updateUndoRedoButton();
    }

    private void redo() {
        if (this.statesForRedo.size() > 0) {
            this.statesForUndo.add(this.currentState);
            this.currentState = this.statesForRedo.removeLast();
        }
        this.updateUndoRedoButton();
    }

    private void updateUndoRedoButton() {
        this.undo.field_146124_l = !this.statesForUndo.isEmpty();
        this.redo.field_146124_l = !this.statesForRedo.isEmpty();
    }

    private boolean handleMouse(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton != 0) {
            return false;
        }
        int offsetMouseX = mouseX - this.guiLeft - 6;
        int offsetMouseY = mouseY - this.guiTop - 9;
        if (this.isInWindow(offsetMouseX, offsetMouseY)) {
            int pixelPosX = offsetMouseX / this.currentState.scaleFactor;
            int pixelPosY = offsetMouseY / this.currentState.scaleFactor;
            if (this.paintingState == null) {
                this.paintingState = new PictureState(this.currentState);
            }
            if (pixelPosX < this.paintingState.picture.length && pixelPosY < this.paintingState.picture.length && this.color != null) {
                this.color = this.activeDrawType.draw(this.paintingState.picture, this.color, pixelPosX, pixelPosY, this.toolSize);
                this.redSlider.func_175218_a((float)this.color.getRed(), false);
                this.blueSlider.func_175218_a((float)this.color.getBlue(), false);
                this.greenSlider.func_175218_a((float)this.color.getGreen(), false);
                this.alphaSlider.func_175218_a((float)this.color.getAlpha(), false);
                return true;
            }
        }
        return false;
    }

    private boolean isInWindow(int offsetMouseX, int offsetMouseY) {
        return offsetMouseX >= 0 && offsetMouseX < this.currentState.picture.length * this.currentState.scaleFactor && offsetMouseY >= 0 && offsetMouseY < this.currentState.picture.length * this.currentState.scaleFactor;
    }

    private void handleSizeChanged() {
        if (this.toolSize >= 10) {
            this.toolSize = 10;
            this.moreSize.field_146124_l = false;
        } else {
            this.moreSize.field_146124_l = true;
        }
        if (this.toolSize <= 1) {
            this.toolSize = 1;
            this.lessSize.field_146124_l = false;
        } else {
            this.lessSize.field_146124_l = true;
        }
    }

    private void saveImage(boolean background) throws IOException {
        BufferedImage paint = new BufferedImage(128 / this.currentState.scaleFactor, 128 / this.currentState.scaleFactor, 2);
        for (int x = 0; x < this.currentState.picture.length; ++x) {
            for (int y = 0; y < this.currentState.picture[0].length; ++y) {
                paint.setRGB(x, y, this.currentState.picture[x][y]);
            }
        }
        BufferedImage output = new BufferedImage(paint.getWidth(), paint.getHeight(), 2);
        if (background) {
            List quads = this.field_146297_k.func_175602_ab().func_184389_a(this.state).func_188616_a(this.state, this.facing.func_176734_d(), 0L);
            for (BakedQuad quad : quads) {
                TextureAtlasSprite sprite = quad.func_187508_a();
                IResource resource = this.field_146297_k.func_110442_L().func_110536_a(this.field_146297_k.func_147117_R().func_184396_a(sprite));
                Throwable throwable = null;
                try {
                    Image image = ImageIO.read(resource.func_110527_b());
                    if (quad.func_178212_b()) {
                        int color = this.field_146297_k.func_184125_al().func_186724_a(this.state, (IBlockAccess)this.field_146297_k.field_71441_e, this.pos, quad.func_178211_c());
                        float red = (float)(color >> 16 & 0xFF) / 255.0f;
                        float green = (float)(color >> 8 & 0xFF) / 255.0f;
                        float blue = (float)(color & 0xFF) / 255.0f;
                        Image asBufferedImage = image;
                        for (int x = 0; x < paint.getWidth(); ++x) {
                            for (int y = 0; y < paint.getHeight(); ++y) {
                                Color originalColor = new Color(((BufferedImage)asBufferedImage).getRGB(x, y), true);
                                int newRed = Math.round((float)originalColor.getRed() * red);
                                int newGreen = Math.round((float)originalColor.getGreen() * green);
                                int newBlue = Math.round((float)originalColor.getBlue() * blue);
                                ((BufferedImage)asBufferedImage).setRGB(x, y, new Color(newRed, newGreen, newBlue, originalColor.getAlpha()).getRGB());
                            }
                        }
                    }
                    image = image.getScaledInstance(output.getWidth(), output.getHeight(), 2);
                    output.getGraphics().drawImage(image, 0, 0, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resource == null) continue;
                    if (throwable != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    resource.close();
                }
            }
        }
        output.getGraphics().drawImage(paint, 0, 0, null);
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select the path to save");
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || !f.getName().contains(".") || f.getName().endsWith(".png");
            }

            @Override
            public String getDescription() {
                return "png";
            }
        });
        LookAndFeel old = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            MCPaint.LOGGER.warn("Unable to set system look and feel", (Throwable)e);
        }
        chooser.setDialogType(1);
        if (chooser.showSaveDialog(null) == 0) {
            File file = chooser.getSelectedFile();
            if (file.isDirectory()) {
                throw new IOException("Expected file, got dir!");
            }
            if (!file.getName().endsWith(".png")) {
                file = new File(file.toString() + ".png");
            }
            if (!ImageIO.write((RenderedImage)output, "png", file)) {
                throw new IOException("Could not encode image as png!");
            }
        }
        try {
            UIManager.setLookAndFeel(old);
        }
        catch (UnsupportedLookAndFeelException e) {
            MCPaint.LOGGER.error("Could not revert look and feel!", (Throwable)e);
        }
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
        this.color = new Color(Math.round(this.redSlider.func_175220_c()), Math.round(this.greenSlider.func_175220_c()), Math.round(this.blueSlider.func_175220_c()), Math.round(this.alphaSlider.func_175220_c()));
    }

    public void func_175319_a(int id, @Nonnull String value) {
    }

    @Nonnull
    public String func_175318_a(int id, @Nonnull String name, float value) {
        return name + ":" + Math.round(value);
    }
}

