/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.render;

import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.MCPaintConfig;
import ichttt.mods.mcpaint.client.render.BufferManager;
import ichttt.mods.mcpaint.client.render.PictureRenderer;
import ichttt.mods.mcpaint.common.EventHandler;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;

public class TESRCanvas
extends TileEntitySpecialRenderer<TileEntityCanvas> {
    private boolean renderedSlow = false;

    public void render(TileEntityCanvas te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        int renderPass = MinecraftForgeClient.getRenderPass();
        if (destroyStage >= 0 && renderPass == 0) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder builder = tessellator.func_178180_c();
            builder.func_78914_f();
            builder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            this.renderBlock(x, y, z, te, builder, destroyStage);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            tessellator.func_78381_a();
        } else if (renderPass == 0) {
            if (!this.renderedSlow) {
                MCPaint.LOGGER.warn("SLOW RENDERING BLOCK!");
                MCPaint.LOGGER.warn("McPaint detected that the fast block rendering path could not be used.");
                MCPaint.LOGGER.warn("This may reduce your FPS significantly");
                MCPaint.LOGGER.warn("This message will only be shown once, even if it occurs after this");
                this.renderedSlow = true;
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            this.func_147499_a(TextureMap.field_110575_b);
            RenderHelper.func_74518_a();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179147_l();
            GlStateManager.func_179129_p();
            if (Minecraft.func_71379_u()) {
                GlStateManager.func_179103_j((int)7425);
            } else {
                GlStateManager.func_179103_j((int)7424);
            }
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            this.renderBlock(x, y, z, te, buffer, -1);
            buffer.func_178969_c(0.0, 0.0, 0.0);
            tessellator.func_78381_a();
            RenderHelper.func_74519_b();
        } else if (renderPass == 1) {
            TESRCanvas.renderPaint(te, x, y, z);
        }
    }

    public void renderTileEntityFast(TileEntityCanvas te, double x, double y, double z, float partialTicks, int destroyStage, float partial, BufferBuilder buffer) {
        int renderPass = MinecraftForgeClient.getRenderPass();
        if (renderPass == 0) {
            this.renderBlock(x, y, z, te, buffer, -1);
        } else if (renderPass == 1) {
            TESRCanvas.renderPaint(te, x, y, z);
        }
    }

    private static void renderPaint(TileEntityCanvas te, double x, double y, double z) {
        double playerDistSq = Minecraft.func_71410_x().field_71439_g.func_174818_b(te.func_174877_v());
        if (playerDistSq < (double)(MCPaintConfig.CLIENT.maxPaintRenderDistance * MCPaintConfig.CLIENT.maxPaintRenderDistance)) {
            int light = te.func_145831_w().func_175626_b(te.func_174877_v(), 0);
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (!te.hasPaintFor(facing)) continue;
                TESRCanvas.renderFace(x, y, z, te, facing, light, playerDistSq);
            }
        } else {
            te.invalidateBuffers();
        }
    }

    private static void renderFace(double x, double y, double z, TileEntityCanvas te, EnumFacing facing, int light, double playerDistSq) {
        boolean slow;
        boolean xOffset = false;
        boolean yOffset = false;
        boolean zOffset = false;
        int angle = 0;
        double translationXOffset = 0.0;
        double translationYOffset = 0.0;
        double translationZOffset = 0.0;
        switch (facing) {
            case NORTH: {
                angle = 0;
                zOffset = true;
                translationZOffset = 0.0015;
                break;
            }
            case EAST: {
                angle = 270;
                translationXOffset = -0.0015;
                break;
            }
            case SOUTH: {
                angle = 180;
                xOffset = true;
                translationZOffset = -0.0015;
                break;
            }
            case WEST: {
                angle = 90;
                xOffset = true;
                zOffset = true;
                translationXOffset = 0.0015;
                break;
            }
            case UP: {
                xOffset = true;
                zOffset = true;
                translationYOffset = -0.0015;
                break;
            }
            case DOWN: {
                yOffset = true;
                zOffset = true;
                translationYOffset = 0.0015;
            }
        }
        if (playerDistSq < 16.0) {
            translationXOffset /= 2.0;
            translationYOffset /= 2.0;
            translationZOffset /= 2.0;
        }
        if (playerDistSq < 36.0) {
            translationXOffset /= 4.0;
            translationYOffset /= 4.0;
            translationZOffset /= 4.0;
        }
        if (playerDistSq < 64.0) {
            translationXOffset /= 2.0;
            translationYOffset /= 2.0;
            translationZOffset /= 2.0;
        }
        if (playerDistSq > 256.0) {
            translationXOffset *= 2.0;
            translationYOffset *= 2.0;
            translationZOffset *= 2.0;
        }
        if (playerDistSq > 1024.0) {
            translationXOffset *= 2.0;
            translationYOffset *= 2.0;
            translationZOffset *= 2.0;
        }
        if (playerDistSq > 4096.0) {
            translationXOffset *= 2.0;
            translationYOffset *= 2.0;
            translationZOffset *= 2.0;
        }
        if (playerDistSq > 9216.0) {
            translationXOffset *= 2.0;
            translationYOffset *= 2.0;
            translationZOffset *= 2.0;
        }
        PictureRenderer.setWorldGLState();
        GlStateManager.func_179137_b((double)(x + translationXOffset + (double)xOffset), (double)(y + translationYOffset + (double)yOffset), (double)(z + translationZOffset + (double)zOffset));
        int j = light % 65536;
        int k = light / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        if (angle != 0) {
            GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (facing.func_176740_k().func_176720_b()) {
            GlStateManager.func_179114_b((float)(facing == EnumFacing.DOWN ? -90.0f : 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(facing == EnumFacing.UP ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        IPaintable paint = te.getPaintFor(facing);
        boolean bl = slow = !MCPaintConfig.CLIENT.optimizePictures;
        if (!slow) {
            BufferManager builder = te.getBuffer(facing);
            if (builder == null) {
                if (playerDistSq < (double)((MCPaintConfig.CLIENT.maxPaintRenderDistance - 8) * (MCPaintConfig.CLIENT.maxPaintRenderDistance - 8))) {
                    slow = true;
                }
            } else {
                Tessellator.func_178181_a().field_178182_b.func_181679_a((BufferBuilder)builder.get(TESRCanvas.getRes(playerDistSq)));
            }
        }
        if (slow) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder builder = tessellator.func_178180_c();
            builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            PictureRenderer.renderInGame(paint.getScaleFactor(), builder, paint.getPictureData());
            tessellator.func_78381_a();
        }
        PictureRenderer.resetWorldGLState();
    }

    public static int getRes(double playerDistSq) {
        if (playerDistSq < 1024.0) {
            return 128;
        }
        if (playerDistSq < 4096.0) {
            return 64;
        }
        if (playerDistSq < 9216.0) {
            return 32;
        }
        if (playerDistSq < 16384.0) {
            return 16;
        }
        return 8;
    }

    private void renderBlock(double x, double y, double z, TileEntityCanvas te, BufferBuilder builder, int destroyStage) {
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBlockState state = te.getContainedState();
        if (state == null) {
            state = EventHandler.CANVAS_WOOD.func_176223_P();
        }
        BlockPos pos = te.func_174877_v();
        builder.func_178969_c(x - (double)pos.func_177958_n(), y - (double)pos.func_177956_o(), z - (double)pos.func_177952_p());
        if (destroyStage >= 0) {
            dispatcher.func_175020_a(state, pos, Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/destroy_stage_" + destroyStage), (IBlockAccess)te.func_145831_w());
        } else {
            dispatcher.func_175019_b().func_178267_a((IBlockAccess)te.func_145831_w(), dispatcher.func_184389_a(state), state, te.func_174877_v(), builder, true);
        }
        builder.func_178969_c(0.0, 0.0, 0.0);
    }
}

