/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.render.batch.pixel;

import ichttt.mods.mcpaint.client.render.batch.pixel.PixelInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class PixelLine
implements Iterable<PixelInfo> {
    public final List<PixelInfo> pixelInfos = new ArrayList<PixelInfo>();

    public PixelLine(PixelInfo info) {
        this.pixelInfos.add(info);
    }

    public boolean canAdd(PixelInfo info) {
        for (PixelInfo info1 : this.pixelInfos) {
            if (!info1.isNeighbourX(info)) continue;
            return true;
        }
        return false;
    }

    public void add(PixelInfo info) {
        if (!this.canAdd(info)) {
            throw new IllegalArgumentException("Cannot add pixel!");
        }
        this.pixelInfos.add(info);
    }

    @Override
    @Nonnull
    public Iterator<PixelInfo> iterator() {
        return this.pixelInfos.iterator();
    }

    public boolean isNeighbour(PixelLine line) {
        if (this.pixelInfos.size() != line.pixelInfos.size()) {
            return false;
        }
        return line.pixelInfos.stream().allMatch(externalPixel -> this.pixelInfos.stream().anyMatch(internalPixel -> internalPixel.isNeighbourY((PixelInfo)externalPixel)));
    }

    public void addAll(PixelLine infos) {
        for (PixelInfo info : infos.pixelInfos) {
            this.add(info);
        }
    }

    public int size() {
        return this.pixelInfos.size();
    }
}

