/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.render.batch.pixel;

import ichttt.mods.mcpaint.client.render.batch.pixel.PixelInfo;
import ichttt.mods.mcpaint.client.render.batch.pixel.PixelLine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PixelRect
implements Iterable<PixelLine> {
    private final List<PixelLine> lines = new ArrayList<PixelLine>();
    public final int color;

    public PixelRect(PixelLine first) {
        this.lines.add(first);
        this.color = first.pixelInfos.get((int)0).color;
    }

    public boolean canAdd(PixelLine line) {
        for (PixelLine line1 : this.lines) {
            if (!line1.isNeighbour(line)) continue;
            return true;
        }
        return false;
    }

    public boolean addLine(PixelLine line) {
        if (this.canAdd(line)) {
            this.lines.add(line);
            return true;
        }
        return false;
    }

    public List<PixelInfo> getMergedLines() {
        ArrayList<PixelInfo> list = new ArrayList<PixelInfo>();
        for (PixelLine line : this.lines) {
            list.addAll(line.pixelInfos);
        }
        return list;
    }

    @Override
    public Iterator<PixelLine> iterator() {
        return this.lines.iterator();
    }

    public boolean couldAdjust(PixelRect rect, int maxSingleDiff, int maxTotalDiff) {
        int bDiff;
        int gDiff;
        int rDiff;
        int otherA = rect.color >> 24 & 0xFF;
        int otherR = rect.color >> 16 & 0xFF;
        int otherG = rect.color >> 8 & 0xFF;
        int otherB = rect.color & 0xFF;
        int a = this.color >> 24 & 0xFF;
        int r = this.color >> 16 & 0xFF;
        int g = this.color >> 8 & 0xFF;
        int b = this.color & 0xFF;
        int aDiff = this.diff(a, otherA);
        if (aDiff + (rDiff = this.diff(r, otherR)) + (gDiff = this.diff(g, otherG)) + (bDiff = this.diff(b, otherB)) > maxTotalDiff) {
            return false;
        }
        return aDiff <= maxSingleDiff && rDiff <= maxSingleDiff && gDiff <= maxSingleDiff && bDiff <= maxSingleDiff;
    }

    public int totalDiffTo(PixelRect rect) {
        int otherA = rect.color >> 24 & 0xFF;
        int otherR = rect.color >> 16 & 0xFF;
        int otherG = rect.color >> 8 & 0xFF;
        int otherB = rect.color & 0xFF;
        int a = this.color >> 24 & 0xFF;
        int r = this.color >> 16 & 0xFF;
        int g = this.color >> 8 & 0xFF;
        int b = this.color & 0xFF;
        int aDiff = this.diff(a, otherA);
        int rDiff = this.diff(r, otherR);
        int gDiff = this.diff(g, otherG);
        int bDiff = this.diff(b, otherB);
        return aDiff + rDiff + gDiff + bDiff;
    }

    private int diff(int a, int b) {
        return Math.abs(a - b);
    }
}

