/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common;

import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.common.block.BlockCanvas;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.common.capability.CapabilityPaintable;
import ichttt.mods.mcpaint.common.capability.CapabilityProvider;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import ichttt.mods.mcpaint.common.item.ItemBrush;
import ichttt.mods.mcpaint.common.item.ItemStamp;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="mcpaint")
public class EventHandler {
    public static final Item BRUSH = (Item)EventHandler.getNull();
    public static final Item STAMP = (Item)EventHandler.getNull();
    public static final BlockCanvas CANVAS_WOOD = (BlockCanvas)((Object)EventHandler.getNull());
    public static final BlockCanvas CANVAS_ROCK = (BlockCanvas)((Object)EventHandler.getNull());
    public static final BlockCanvas CANVAS_GROUND = (BlockCanvas)((Object)EventHandler.getNull());

    @Nonnull
    private static <T> T getNull() {
        return null;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)new ItemBrush(new ResourceLocation("mcpaint", "brush")));
        registry.register((IForgeRegistryEntry)new ItemStamp(new ResourceLocation("mcpaint", "stamp")));
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)new BlockCanvas(Material.field_151575_d, new ResourceLocation("mcpaint", "canvas_wood")));
        event.getRegistry().register((IForgeRegistryEntry)new BlockCanvas(Material.field_151576_e, new ResourceLocation("mcpaint", "canvas_rock")));
        event.getRegistry().register((IForgeRegistryEntry)new BlockCanvas(Material.field_151578_c, new ResourceLocation("mcpaint", "canvas_ground")));
        GameRegistry.registerTileEntity(TileEntityCanvas.class, (ResourceLocation)new ResourceLocation("mcpaint", "canvas"));
    }

    @SubscribeEvent
    public static void attachCaps(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() == STAMP) {
            event.addCapability(CapabilityProvider.LOCATION, (ICapabilityProvider)new CapabilityProvider());
        }
    }

    @SubscribeEvent
    public static void onConfigChange(ConfigChangedEvent event) {
        if (event.getModID().equals("mcpaint")) {
            ConfigManager.sync((String)"mcpaint", (Config.Type)Config.Type.INSTANCE);
            MCPaint.proxy.onConfigReload();
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getEntityPlayer().func_184586_b(event.getHand());
        if (event.getEntityPlayer().func_70093_af() && stack.func_77973_b() == STAMP) {
            ((IPaintable)Objects.requireNonNull(stack.getCapability(CapabilityPaintable.PAINTABLE, null))).clear(null, null);
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void missingMapping(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            if (!entry.key.equals((Object)new ResourceLocation("mcpaint", "canvas"))) continue;
            entry.remap((IForgeRegistryEntry)CANVAS_GROUND);
        }
    }
}

