/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common;

import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import ichttt.mods.mcpaint.networking.MessageClearSide;
import ichttt.mods.mcpaint.networking.MessagePaintData;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class MCPaintUtil {
    public static boolean isPosInvalid(NetHandlerPlayServer handler, BlockPos pos) {
        if (!handler.field_147369_b.field_70170_p.func_175667_e(pos)) {
            MCPaint.LOGGER.warn("Player" + handler.field_147369_b.func_70005_c_() + " is trying to write to unloaded block");
            handler.func_194028_b((ITextComponent)new TextComponentString("Trying to write to unloaded block"));
            return true;
        }
        if (handler.field_147369_b.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > (double)(Math.round(handler.field_147369_b.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e()) + 5L)) {
            MCPaint.LOGGER.warn("Player" + handler.field_147369_b.func_70005_c_() + " is writing to out of reach block!");
            return true;
        }
        return false;
    }

    public static int[][] copyOf(int[][] array) {
        int[][] copy = new int[array.length][];
        for (int i = 0; i < array.length; ++i) {
            copy[i] = (int[])array[i].clone();
        }
        return copy;
    }

    public static boolean[][] copyOf(boolean[][] array) {
        boolean[][] copy = new boolean[array.length][];
        for (int i = 0; i < array.length; ++i) {
            copy[i] = (boolean[])array[i].clone();
        }
        return copy;
    }

    public static void uploadPictureToServer(TileEntity te, EnumFacing facing, byte scaleFactor, int[][] picture, boolean clear) {
        if (!(te instanceof TileEntityCanvas)) {
            MCPaint.LOGGER.error("Could not set paint! Found block " + te.func_145838_q());
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentString("Could not set paint!"), true);
            return;
        }
        TileEntityCanvas canvas = (TileEntityCanvas)te;
        if (clear) {
            MCPaint.NETWORKING.sendToServer((IMessage)new MessageClearSide(te.func_174877_v(), facing));
            canvas.removePaint(facing);
        } else {
            MessagePaintData.createAndSend(te.func_174877_v(), facing, scaleFactor, picture, arg_0 -> ((SimpleNetworkWrapper)MCPaint.NETWORKING).sendToServer(arg_0));
            IPaintable paintable = canvas.getPaintFor(facing);
            paintable.setData(scaleFactor, picture, canvas, facing);
        }
    }
}

