/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common;

import com.google.common.base.Function;
import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.common.block.BlockCanvas;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.providers.HarvestInfoTools;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class OneProbeCompat
implements Function<ITheOneProbe, Void>,
IProbeConfigProvider,
IProbeInfoProvider {
    private static final Method showHarvestInfoMethod;

    @Nullable
    public Void apply(@Nullable ITheOneProbe input) {
        if (input != null && showHarvestInfoMethod == null) {
            input.registerProvider((IProbeInfoProvider)this);
            input.registerProbeConfigProvider((IProbeConfigProvider)this);
        }
        return null;
    }

    private static IBlockState getReal(IBlockState state, IBlockAccess world, IProbeHitData data) {
        TileEntity te;
        if (state.func_177230_c() instanceof BlockCanvas && world != null && (te = world.func_175625_s(data.getPos())) instanceof TileEntityCanvas) {
            return ((TileEntityCanvas)te).getContainedState();
        }
        return null;
    }

    public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
    }

    public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        IBlockState real = OneProbeCompat.getReal(blockState, (IBlockAccess)world, data);
        if (real != null) {
            config.showHarvestLevel(IProbeConfig.ConfigMode.NOT);
            config.showCanBeHarvested(IProbeConfig.ConfigMode.NOT);
        }
    }

    public String getID() {
        return "mcpaint";
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        IBlockState real = OneProbeCompat.getReal(blockState, (IBlockAccess)world, data);
        if (real != null) {
            try {
                showHarvestInfoMethod.invoke(null, probeInfo, world, data.getPos(), real.func_177230_c(), real, player);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Impossible reflection failure: ", e);
            }
            catch (InvocationTargetException e) {
                MCPaint.LOGGER.error("Error invoking showHarvestInfo: ", (Throwable)e);
            }
        }
    }

    static {
        Method method;
        try {
            method = HarvestInfoTools.class.getDeclaredMethod("showHarvestInfo", IProbeInfo.class, World.class, BlockPos.class, Block.class, IBlockState.class, EntityPlayer.class);
            method.setAccessible(true);
        }
        catch (LinkageError | ReflectiveOperationException e) {
            MCPaint.LOGGER.error("Couldn't hack into the one probe! Harvest info will be missing from painted blocks!", e);
            method = null;
        }
        showHarvestInfoMethod = method;
    }
}

