/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.block;

import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCanvas
extends Block {
    public static final PropertyBool IS_FULL_BLOCK = PropertyBool.func_177716_a((String)"full_block");
    public static final PropertyBool IS_NORMAL_CUBE = PropertyBool.func_177716_a((String)"normal_cube");
    public static final PropertyBool IS_OPAQUE_CUBE = PropertyBool.func_177716_a((String)"opaque_cube");

    public BlockCanvas(Material material, ResourceLocation regNam) {
        super(material);
        this.func_149711_c(1.0f);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149752_b(5.0f);
        this.field_149783_u = true;
        this.setRegistryName(regNam);
        this.func_149663_c(regNam.func_110624_b() + "." + regNam.func_110623_a());
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)IS_FULL_BLOCK, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)IS_NORMAL_CUBE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)IS_OPAQUE_CUBE, (Comparable)Boolean.valueOf(true)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileEntityCanvas();
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public float func_176195_g(IBlockState blockState, World world, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_185887_b(world, pos);
        }
        return super.func_176195_g(blockState, world, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_177230_c().getExplosionResistance(world, pos, exploder, explosion);
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    @Nonnull
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_177230_c().getSoundType(canvas.getContainedState(), world, pos, entity);
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (te instanceof TileEntityCanvas && ((TileEntityCanvas)te).getContainedState() != null) {
            TileEntityCanvas canvas = (TileEntityCanvas)te;
            state = canvas.getContainedState();
            state.func_177230_c().func_180657_a(world, player, pos, state, te, stack);
            return;
        }
        super.func_180657_a(world, player, pos, state, te, stack);
    }

    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public boolean canHarvestBlock(IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_177230_c().canHarvestBlock(world, pos, player);
        }
        return super.canHarvestBlock(world, pos, player);
    }

    public void func_185477_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            canvas.getContainedState().func_177230_c().func_185477_a(canvas.getContainedState(), world, pos, entityBox, collidingBoxes, entityIn, isActualState);
            return;
        }
        super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entityIn, isActualState);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_185890_d(world, pos);
        }
        return super.func_180646_a(blockState, world, pos);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)source.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_185900_c(source, pos);
        }
        return super.func_185496_a(state, source, pos);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_185909_g(world, pos);
        }
        return super.func_180659_g(state, world, pos);
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        StackTraceElement[] stackTrace;
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null && (stackTrace = Thread.currentThread().getStackTrace()).length > 2 && stackTrace[2].toString().contains("net.minecraftforge.common.ForgeHooks.canHarvestBlock")) {
            return canvas.getContainedState();
        }
        return super.func_176221_a(state, world, pos);
    }

    public int func_176201_c(IBlockState state) {
        if (state.func_177230_c() != this) {
            return state.func_177230_c().func_176201_c(state);
        }
        int meta = 0;
        if (!((Boolean)state.func_177229_b((IProperty)IS_OPAQUE_CUBE)).booleanValue()) {
            meta |= 4;
        }
        if (!((Boolean)state.func_177229_b((IProperty)IS_NORMAL_CUBE)).booleanValue()) {
            meta |= 2;
        }
        if (!((Boolean)state.func_177229_b((IProperty)IS_FULL_BLOCK)).booleanValue()) {
            meta |= 1;
        }
        return meta;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IS_FULL_BLOCK, IS_NORMAL_CUBE, IS_OPAQUE_CUBE});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        if ((meta & 4) > 0) {
            state = state.func_177226_a((IProperty)IS_OPAQUE_CUBE, (Comparable)Boolean.valueOf(false));
        }
        if ((meta & 2) > 0) {
            state = state.func_177226_a((IProperty)IS_NORMAL_CUBE, (Comparable)Boolean.valueOf(false));
        }
        if ((meta & 1) > 0) {
            state = state.func_177226_a((IProperty)IS_FULL_BLOCK, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            state = canvas.getContainedState();
            return state.func_177230_c().getPickBlock(canvas.getContainedState(), target, world, pos, player);
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_149730_j(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)IS_FULL_BLOCK);
    }

    public boolean func_149686_d(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)IS_FULL_BLOCK);
    }

    public boolean func_149721_r(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)IS_NORMAL_CUBE);
    }

    public boolean func_149662_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)IS_OPAQUE_CUBE);
    }

    public boolean func_149637_q(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)IS_FULL_BLOCK);
    }

    public IBlockState getStateFrom(IBlockState state) {
        return this.func_176223_P().func_177226_a((IProperty)IS_OPAQUE_CUBE, (Comparable)Boolean.valueOf(state.func_185914_p())).func_177226_a((IProperty)IS_NORMAL_CUBE, (Comparable)Boolean.valueOf(state.func_185915_l())).func_177226_a((IProperty)IS_FULL_BLOCK, (Comparable)Boolean.valueOf(state.func_185913_b()));
    }
}

