/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.block;

import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.MCPaintConfig;
import ichttt.mods.mcpaint.client.render.BufferManager;
import ichttt.mods.mcpaint.client.render.CachedBufferBuilder;
import ichttt.mods.mcpaint.client.render.batch.IOptimisationCallback;
import ichttt.mods.mcpaint.client.render.batch.RenderCache;
import ichttt.mods.mcpaint.client.render.batch.SimpleCallback;
import ichttt.mods.mcpaint.common.capability.CapabilityPaintable;
import ichttt.mods.mcpaint.common.capability.IPaintValidator;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import ichttt.mods.mcpaint.common.capability.Paint;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCanvas
extends TileEntity
implements IPaintValidator {
    private final Map<EnumFacing, IPaintable> facingToPaintMap = new EnumMap<EnumFacing, IPaintable>(EnumFacing.class);
    private IBlockState containedState;
    private final Map<EnumFacing, Object> bufferMap = new EnumMap<EnumFacing, Object>(EnumFacing.class);
    private final Set<EnumFacing> disallowedFaces = EnumSet.noneOf(EnumFacing.class);

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        NBTUtil.func_190009_a((NBTTagCompound)tag, (IBlockState)this.containedState);
        NBTTagCompound faces = new NBTTagCompound();
        for (Map.Entry<EnumFacing, IPaintable> entry : this.facingToPaintMap.entrySet()) {
            faces.func_74782_a(entry.getKey().func_176610_l(), (NBTBase)CapabilityPaintable.writeToNBT(entry.getValue(), new NBTTagCompound()));
        }
        tag.func_74782_a("faces", (NBTBase)faces);
        if (!this.disallowedFaces.isEmpty()) {
            NBTTagCompound blockedFaces = new NBTTagCompound();
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                blockedFaces.func_74757_a(facing.func_176610_l(), this.disallowedFaces.contains(facing));
            }
            tag.func_74782_a("blocked", (NBTBase)blockedFaces);
        }
        return tag;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.containedState = NBTUtil.func_190008_d((NBTTagCompound)tag);
        NBTTagCompound faces = tag.func_74775_l("faces");
        for (String key : faces.func_150296_c()) {
            Paint paint = new Paint(this);
            CapabilityPaintable.readFromNBT(paint, faces.func_74775_l(key));
            this.facingToPaintMap.put(EnumFacing.func_176739_a((String)key), paint);
        }
        this.disallowedFaces.clear();
        if (tag.func_150297_b("blocked", 10)) {
            NBTTagCompound blockedFaces = tag.func_74775_l("blocked");
            for (String key : blockedFaces.func_150296_c()) {
                if (!blockedFaces.func_74767_n(key)) continue;
                this.disallowedFaces.add(EnumFacing.func_176739_a((String)key));
            }
        }
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityPaintable.PAINTABLE) {
            return (T)CapabilityPaintable.PAINTABLE.cast((Object)this.getPaintFor(facing));
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityPaintable.PAINTABLE || super.hasCapability(capability, facing);
    }

    @Override
    public boolean isValidPixelCount(short pixelCountX, short pixelCountY) {
        return pixelCountX == 0 && pixelCountY == 0 || pixelCountX == 128 && pixelCountY == 128;
    }

    public void setInitialData(IBlockState state, Set<EnumFacing> disallowedFaces) {
        this.containedState = state;
        this.disallowedFaces.addAll(disallowedFaces);
        this.func_70296_d();
    }

    public IBlockState getContainedState() {
        return this.containedState;
    }

    public IPaintable getPaintFor(EnumFacing facing) {
        return this.facingToPaintMap.computeIfAbsent(facing, face -> new Paint(this));
    }

    public boolean hasPaintFor(EnumFacing facing) {
        IPaintable paint = this.facingToPaintMap.get(facing);
        if (paint == null) {
            return false;
        }
        return paint.hasPaintData();
    }

    @SideOnly(value=Side.CLIENT)
    public BufferManager getBuffer(final EnumFacing facing) {
        Object obj = this.bufferMap.get(facing);
        if (obj instanceof BufferManager) {
            return (BufferManager)obj;
        }
        if (obj instanceof IOptimisationCallback) {
            return null;
        }
        if (obj != null) {
            MCPaint.LOGGER.error("Unknown object " + obj);
            return null;
        }
        SimpleCallback callback = new SimpleCallback(){

            @Override
            public void provideFinishedBuffer(BufferManager builder) {
                if (this.isInvalid()) {
                    return;
                }
                RenderCache.cache(TileEntityCanvas.this.getPaintFor(facing), builder);
                TileEntityCanvas.this.bufferMap.put(facing, builder);
            }
        };
        this.bufferMap.put(facing, callback);
        RenderCache.getOrRequest(this.facingToPaintMap.get(facing), callback);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void invalidateBuffers() {
        for (Map.Entry<EnumFacing, Object> entry : this.bufferMap.entrySet()) {
            Object obj = entry.getValue();
            if (obj instanceof SimpleCallback) {
                ((SimpleCallback)obj).invalidate();
                continue;
            }
            if (!(obj instanceof BufferManager)) continue;
            RenderCache.cache(this.getPaintFor(entry.getKey()), (BufferManager)obj);
        }
        this.bufferMap.clear();
    }

    public double func_145833_n() {
        return MCPaintConfig.CLIENT.maxRenderDistance * MCPaintConfig.CLIENT.maxRenderDistance;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.invalidateBuffers();
    }

    public void invalidateBuffer(EnumFacing facing) {
        Object obj = this.bufferMap.remove(facing);
        if (obj instanceof SimpleCallback) {
            ((SimpleCallback)obj).invalidate();
        } else if (obj instanceof CachedBufferBuilder) {
            RenderCache.uncache(this.getPaintFor(facing));
        }
    }

    public boolean isSideBlockedForPaint(EnumFacing facing) {
        return this.disallowedFaces.contains(facing);
    }

    public void removePaint(EnumFacing facing) {
        this.facingToPaintMap.remove(facing);
    }
}

