/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.capability;

import ichttt.mods.mcpaint.common.capability.IPaintable;
import ichttt.mods.mcpaint.common.capability.Paint;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class CapabilityPaintable {
    @CapabilityInject(value=IPaintable.class)
    public static Capability<IPaintable> PAINTABLE;

    public static void register() {
        CapabilityManager.INSTANCE.register(IPaintable.class, (Capability.IStorage)new Capability.IStorage<IPaintable>(){

            public NBTBase writeNBT(Capability<IPaintable> capability, IPaintable instance, EnumFacing side) {
                return CapabilityPaintable.writeToNBT(instance, new NBTTagCompound());
            }

            public void readNBT(Capability<IPaintable> capability, IPaintable instance, EnumFacing side, NBTBase nbt) {
                CapabilityPaintable.readFromNBT(instance, (NBTTagCompound)nbt);
            }
        }, Paint::new);
    }

    public static NBTTagCompound writeToNBT(IPaintable instance, NBTTagCompound compound) {
        if (instance.hasPaintData()) {
            short pixelCountX = instance.getPixelCountX();
            byte scaleFactor = instance.getScaleFactor();
            int[][] pictureData = instance.getPictureData();
            compound.func_74777_a("pixelX", pixelCountX);
            compound.func_74774_a("scale", scaleFactor);
            NBTTagCompound pictureInfo = new NBTTagCompound();
            for (int i = 0; i < pixelCountX / scaleFactor; ++i) {
                pictureInfo.func_74783_a("" + i, pictureData[i]);
            }
            compound.func_74782_a("picture", (NBTBase)pictureInfo);
            return compound;
        }
        return compound;
    }

    public static void readFromNBT(IPaintable instance, NBTTagCompound compound) {
        if (!compound.func_150297_b("scale", 1)) {
            return;
        }
        short pixelCountX = compound.func_74765_d("pixelX");
        byte scaleFactor = compound.func_74771_c("scale");
        NBTTagCompound pictureInfo = compound.func_74775_l("picture");
        int arraySize = pixelCountX / scaleFactor;
        int[][] pictureData = new int[arraySize][];
        for (int i = 0; i < arraySize; ++i) {
            pictureData[i] = pictureInfo.func_74759_k("" + i);
        }
        instance.setData(scaleFactor, pictureData, null, null);
    }
}

