/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.capability;

import ichttt.mods.mcpaint.common.capability.CapabilityPaintable;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import ichttt.mods.mcpaint.common.capability.Paint;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class CapabilityProvider
implements ICapabilitySerializable<NBTTagCompound> {
    public static final ResourceLocation LOCATION = new ResourceLocation("mcpaint", "paintable");
    private final IPaintable paint = new Paint();

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityPaintable.PAINTABLE;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityPaintable.PAINTABLE) {
            return (T)this.paint;
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        return CapabilityPaintable.writeToNBT(this.paint, new NBTTagCompound());
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        CapabilityPaintable.readFromNBT(this.paint, nbt);
    }
}

