/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.item;

import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.common.EventHandler;
import ichttt.mods.mcpaint.common.block.BlockCanvas;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemBrush
extends Item {
    public ItemBrush(ResourceLocation registryName) {
        this.func_77637_a(CreativeTabs.field_78031_c);
        this.setRegistryName(registryName);
        this.func_77655_b(registryName.func_110624_b() + "." + registryName.func_110623_a());
        this.func_77625_d(1);
        this.func_77656_e(32);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockCanvas) {
            ItemStack held = player.func_184586_b(hand);
            TileEntityCanvas canvas = (TileEntityCanvas)Objects.requireNonNull(world.func_175625_s(pos));
            if (canvas.isSideBlockedForPaint(facing)) {
                return EnumActionResult.FAIL;
            }
            this.startPainting(canvas, world, held, pos, facing.func_176734_d(), state);
            held.func_77972_a(1, (EntityLivingBase)player);
            return EnumActionResult.SUCCESS;
        }
        if (state.func_193401_d((IBlockAccess)world, pos, facing) == BlockFaceShape.SOLID && state.func_185904_a().func_76218_k() && state.func_185913_b() == state.func_185917_h() && state.func_185917_h() == state.func_185898_k() && state.func_185901_i() == EnumBlockRenderType.MODEL && !state.func_177230_c().hasTileEntity(state)) {
            EnumSet<EnumFacing> disallowedFaces = EnumSet.noneOf(EnumFacing.class);
            for (EnumFacing testFacing : EnumFacing.field_82609_l) {
                if (state.func_193401_d((IBlockAccess)world, pos, testFacing) == BlockFaceShape.SOLID) continue;
                disallowedFaces.add(testFacing);
            }
            ItemStack held = player.func_184586_b(hand);
            if (state.func_185904_a().func_76217_h()) {
                world.func_175656_a(pos, EventHandler.CANVAS_WOOD.getStateFrom(state));
            } else if (state.func_185904_a().func_76229_l()) {
                world.func_175656_a(pos, EventHandler.CANVAS_GROUND.getStateFrom(state));
            } else {
                world.func_175656_a(pos, EventHandler.CANVAS_ROCK.getStateFrom(state));
            }
            TileEntityCanvas canvas = (TileEntityCanvas)Objects.requireNonNull(world.func_175625_s(pos));
            canvas.setInitialData(state, disallowedFaces);
            canvas.func_70296_d();
            this.startPainting(canvas, world, held, pos, facing.func_176734_d(), state);
            held.func_77972_a(1, (EntityLivingBase)player);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    protected void startPainting(TileEntityCanvas canvas, World world, ItemStack heldItem, BlockPos pos, EnumFacing facing, IBlockState state) {
        if (world.field_72995_K) {
            if (canvas.hasPaintFor(facing)) {
                ArrayList<IPaintable> list = new ArrayList<IPaintable>(1);
                list.add(canvas.getPaintFor(facing));
                MCPaint.proxy.showGuiDraw(list, canvas.func_174877_v(), facing, canvas.getContainedState());
            } else {
                MCPaint.proxy.showGuiDraw(pos, facing, canvas.getContainedState());
            }
        }
    }
}

