/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.item;

import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.MCPaintConfig;
import ichttt.mods.mcpaint.common.MCPaintUtil;
import ichttt.mods.mcpaint.common.block.BlockCanvas;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.common.capability.CapabilityPaintable;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import ichttt.mods.mcpaint.common.item.ItemBrush;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemStamp
extends ItemBrush {
    public ItemStamp(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack hold = player.func_184586_b(hand);
        IPaintable paint = (IPaintable)Objects.requireNonNull(hold.getCapability(CapabilityPaintable.PAINTABLE, null));
        if (paint.hasPaintData()) {
            return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
        }
        if (player.func_70093_af()) {
            TileEntityCanvas canvas;
            TileEntity te;
            facing = facing.func_176734_d();
            if (state.func_177230_c() instanceof BlockCanvas && (te = world.func_175625_s(pos)) instanceof TileEntityCanvas && (canvas = (TileEntityCanvas)te).hasPaintFor(facing)) {
                paint.copyFrom(canvas.getPaintFor(facing), canvas, facing);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    @Override
    protected void startPainting(TileEntityCanvas canvas, World world, ItemStack heldItem, BlockPos pos, EnumFacing facing, IBlockState state) {
        if (world.field_72995_K) {
            IPaintable heldPaint = (IPaintable)Objects.requireNonNull(heldItem.getCapability(CapabilityPaintable.PAINTABLE, null), "No paint in stamp");
            if (MCPaintConfig.CLIENT.directApplyStamp) {
                canvas.getPaintFor(facing).copyFrom(heldPaint, canvas, facing);
                MCPaintUtil.uploadPictureToServer(canvas, facing, heldPaint.getScaleFactor(), heldPaint.getPictureData(), false);
            } else {
                LinkedList<IPaintable> paintList = new LinkedList<IPaintable>();
                if (canvas.hasPaintFor(facing)) {
                    paintList.add(canvas.getPaintFor(facing));
                }
                paintList.add(heldPaint);
                MCPaint.proxy.showGuiDraw(paintList, pos, facing, canvas.getContainedState());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        IPaintable paintable = (IPaintable)stack.getCapability(CapabilityPaintable.PAINTABLE, null);
        if (paintable != null && paintable.hasPaintData()) {
            tooltip.add(I18n.func_135052_a((String)"mcpaint.tooltip.stamp.paint", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"mcpaint.tooltip.stamp.nopaint", (Object[])new Object[0]));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

