/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.networking;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.primitives.Shorts;
import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.common.MCPaintUtil;
import ichttt.mods.mcpaint.common.block.BlockCanvas;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.networking.MessageClearSide;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessagePaintData
implements IMessage {
    private BlockPos pos;
    private EnumFacing facing;
    private byte scale;
    private byte part;
    private byte maxParts;
    private int[][] data;

    public MessagePaintData() {
    }

    public static void createAndSend(BlockPos pos, EnumFacing facing, byte scale, int[][] data, Consumer<MessagePaintData> sender) {
        int length = data.length;
        if (length > 0) {
            length *= data[0].length;
        }
        if (length > 8000) {
            int partsAsInt = length / 8000 + 1;
            while (data.length % partsAsInt != 0) {
                if (++partsAsInt <= 32) continue;
                throw new RuntimeException("Hell I'm not sending " + partsAsInt + "+ packets for a single image of length " + length);
            }
            if (partsAsInt > 127) {
                throw new IllegalArgumentException("Picture too large: " + length);
            }
            byte parts = (byte)partsAsInt;
            for (byte b = 1; b <= parts; b = (byte)(b + 1)) {
                MessagePaintData toSend = new MessagePaintData(pos, facing, scale, data, b, parts);
                sender.accept(toSend);
            }
        } else {
            MessagePaintData toSend = new MessagePaintData(pos, facing, scale, data, 0, 0);
            sender.accept(toSend);
        }
    }

    public MessagePaintData(BlockPos pos, EnumFacing facing, byte scale, int[][] data, byte part, byte maxParts) {
        this.pos = pos;
        this.facing = facing;
        this.scale = scale;
        this.data = data;
        this.part = part;
        this.maxParts = maxParts;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.scale = buf.readByte();
        this.facing = EnumFacing.func_82600_a((int)buf.readByte());
        this.part = buf.readByte();
        this.maxParts = buf.readByte();
        int max = buf.readShort();
        int secondMax = buf.readShort();
        this.data = new int[max][secondMax];
        for (int i = 0; i < max; ++i) {
            for (int j = 0; j < secondMax; ++j) {
                this.data[i][j] = buf.readInt();
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeByte((int)this.scale);
        buf.writeByte(this.facing.func_176745_a());
        buf.writeByte((int)this.part);
        buf.writeByte((int)this.maxParts);
        int max = Shorts.checkedCast((long)(this.maxParts == 0 ? (long)this.data.length : (long)(this.data.length / this.maxParts)));
        buf.writeShort((int)Shorts.checkedCast((long)max));
        buf.writeShort((int)Shorts.checkedCast((long)this.data[0].length));
        int offset = this.maxParts == 0 ? max : max * this.part;
        for (int i = offset - max; i < offset; ++i) {
            int[] subarray;
            for (int value : subarray = this.data[i]) {
                buf.writeInt(value);
            }
        }
    }

    public static class ClientHandler
    extends ServerHandler {
        @Override
        @SideOnly(value=Side.CLIENT)
        protected void handleSide(MessageContext ctx, BlockPos pos, EnumFacing facing, byte scale, int[][] data) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                TileEntity te;
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                if (!world.func_175667_e(pos)) {
                    MCPaint.LOGGER.warn("Invalid pos " + pos + " when updating data - Not loaded");
                }
                if (!((te = world.func_175625_s(pos)) instanceof TileEntityCanvas)) {
                    MCPaint.LOGGER.warn("Invalid block at pos " + pos + " when updating data - TE invalid");
                    return;
                }
                TileEntityCanvas canvas = (TileEntityCanvas)te;
                canvas.getPaintFor(facing).setData(scale, data, canvas, facing);
                te.func_70296_d();
            });
        }
    }

    public static class ServerHandler
    implements IMessageHandler<MessagePaintData, IMessage> {
        private final Multimap<BlockPos, MessagePaintData> partMap = MultimapBuilder.hashKeys().hashSetValues().build();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IMessage onMessage(MessagePaintData message, MessageContext ctx) {
            if (message.maxParts == 0) {
                this.handleSide(ctx, message.pos, message.facing, message.scale, message.data);
            } else {
                Multimap<BlockPos, MessagePaintData> multimap = this.partMap;
                synchronized (multimap) {
                    this.partMap.put((Object)message.pos, (Object)message);
                    Collection messages = this.partMap.get((Object)message.pos);
                    if (messages.size() == message.maxParts) {
                        int[][] data = new int[message.data.length * message.maxParts][message.data[0].length];
                        messages.stream().sorted(Comparator.comparingInt(o -> ((MessagePaintData)o).part)).forEachOrdered(messagePaintData -> {
                            int offset = ((MessagePaintData)messagePaintData).data.length * (((MessagePaintData)messagePaintData).part - 1);
                            for (int i = 0; i < ((MessagePaintData)messagePaintData).data.length; ++i) {
                                int[] subarray = ((MessagePaintData)messagePaintData).data[i];
                                System.arraycopy(((MessagePaintData)messagePaintData).data[i], 0, data[i + offset], 0, subarray.length);
                            }
                        });
                        this.partMap.removeAll((Object)message.pos);
                        this.handleSide(ctx, message.pos, message.facing, message.scale, data);
                    }
                }
            }
            return null;
        }

        protected void handleSide(MessageContext ctx, BlockPos pos, EnumFacing facing, byte scale, int[][] data) {
            ServerHandler.setServerData(ctx, pos, facing, scale, data);
        }

        public static void setServerData(MessageContext ctx, BlockPos pos, EnumFacing facing, byte scale, int[][] data) {
            NetHandlerPlayServer handler = ctx.getServerHandler();
            handler.field_147369_b.field_71133_b.func_152344_a(() -> {
                if (MCPaintUtil.isPosInvalid(handler, pos)) {
                    return;
                }
                IBlockState state = handler.field_147369_b.field_70170_p.func_180495_p(pos);
                if (!(state.func_177230_c() instanceof BlockCanvas)) {
                    MCPaint.LOGGER.warn("Invalid block at pos " + pos + " has been selected by player " + handler.field_147369_b.func_70005_c_() + " - Block invalid");
                    return;
                }
                TileEntity te = handler.field_147369_b.field_70170_p.func_175625_s(pos);
                if (!(te instanceof TileEntityCanvas)) {
                    MCPaint.LOGGER.warn("Invalid block at pos " + pos + " has been selected by player " + handler.field_147369_b.func_70005_c_() + " - TE invalid");
                    return;
                }
                TileEntityCanvas canvas = (TileEntityCanvas)te;
                if (data == null) {
                    canvas.removePaint(facing);
                } else {
                    canvas.getPaintFor(facing).setData(scale, data, canvas, facing);
                }
                te.func_70296_d();
                NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(handler.field_147369_b.field_70170_p.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), -1.0);
                if (data == null) {
                    MCPaint.NETWORKING.sendToAllTracking((IMessage)new MessageClearSide(pos, facing), point);
                } else {
                    MessagePaintData.createAndSend(pos, facing, scale, data, messagePaintData -> MCPaint.NETWORKING.sendToAllTracking((IMessage)messagePaintData, point));
                }
            });
        }
    }
}

