/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint;

import ichttt.mods.mcpaint.client.ClientEventHandler;
import ichttt.mods.mcpaint.common.EventHandler;
import ichttt.mods.mcpaint.common.block.BlockCanvas;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.common.capability.CapabilityPaintable;
import ichttt.mods.mcpaint.common.item.ItemBrush;
import ichttt.mods.mcpaint.common.item.ItemStamp;
import ichttt.mods.mcpaint.networking.MessageClearSide;
import ichttt.mods.mcpaint.networking.MessageDrawAbort;
import ichttt.mods.mcpaint.networking.MessagePaintData;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mcpaint")
public class MCPaint {
    public static final String MODID = "mcpaint";
    public static final Logger LOGGER = LogManager.getLogger((String)"mcpaint");
    private static final String NETWORKING_MAJOR = "1.";
    private static final String NETWORKING_MINOR = "0";
    private static final String NETWORKING_VERSION = "1.0";
    public static SimpleChannel NETWORKING;

    public MCPaint() {
        MinecraftForge.EVENT_BUS.register(EventHandler.class);
        FMLJavaModLoadingContext.get().getModEventBus().register(MCPaint.class);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientEventHandler::setupClient));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        NETWORKING = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, "channel"), () -> NETWORKING_VERSION, s -> s.startsWith(NETWORKING_MAJOR), s -> s.equals(NETWORKING_VERSION));
        NETWORKING.registerMessage(1, MessagePaintData.class, MessagePaintData::encode, MessagePaintData::new, MessagePaintData.ServerHandler.INSTANCE::onMessage);
        NETWORKING.registerMessage(2, MessageDrawAbort.class, MessageDrawAbort::encode, MessageDrawAbort::new, MessageDrawAbort.Handler::onMessage);
        NETWORKING.registerMessage(3, MessagePaintData.ClientMessage.class, MessagePaintData::encode, MessagePaintData.ClientMessage::new, (clientMessage, supplier) -> {
            DistExecutor.runWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> {
                throw new RuntimeException("MessagePaintData.ClientMessage cannot be run on server!");
            });
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> MCPaint.lambda$null$8(clientMessage, (Supplier)supplier));
        });
        NETWORKING.registerMessage(4, MessageClearSide.class, MessageClearSide::encode, MessageClearSide::new, MessageClearSide.Handler::onMessage);
        CapabilityPaintable.register();
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)new ItemBrush(new ResourceLocation(MODID, "brush")));
        registry.register((IForgeRegistryEntry)new ItemStamp(new ResourceLocation(MODID, "stamp")));
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)new BlockCanvas(Material.field_151575_d, new ResourceLocation(MODID, "canvas_wood")));
        event.getRegistry().register((IForgeRegistryEntry)new BlockCanvas(Material.field_151576_e, new ResourceLocation(MODID, "canvas_rock")));
        event.getRegistry().register((IForgeRegistryEntry)new BlockCanvas(Material.field_151578_c, new ResourceLocation(MODID, "canvas_ground")));
    }

    @SubscribeEvent
    public static void registerTileEntity(RegistryEvent.Register<TileEntityType<?>> event) {
        TileEntityType type = (TileEntityType)TileEntityType.Builder.func_200963_a(TileEntityCanvas::new).func_206865_a(null).setRegistryName(MODID, "canvas_te");
        event.getRegistry().register((IForgeRegistryEntry)type);
    }

    private static /* synthetic */ Runnable lambda$null$8(MessagePaintData.ClientMessage clientMessage, Supplier supplier) {
        return () -> MCPaint.lambda$null$7(clientMessage, (Supplier)supplier);
    }

    private static /* synthetic */ void lambda$null$7(MessagePaintData.ClientMessage clientMessage, Supplier supplier) {
        MessagePaintData.ClientHandler.INSTANCE.onMessage(clientMessage, supplier);
    }
}

