/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.render;

import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.MCPaintConfig;
import ichttt.mods.mcpaint.client.render.CachedBufferBuilder;

public class BufferManager {
    private final CachedBufferBuilder[] mips;
    private final CachedBufferBuilder fullSize;
    private final int fullSizeRect;
    private final int maxSize;
    private int[] sizes;

    public BufferManager(CachedBufferBuilder fullSize, int fullSizeRect, int maxMips, int maxSize) {
        this.fullSize = fullSize;
        this.fullSizeRect = fullSizeRect;
        this.maxSize = maxSize;
        this.mips = new CachedBufferBuilder[maxMips];
        this.sizes = new int[maxMips];
    }

    public CachedBufferBuilder get(int resolution) {
        if (resolution >= this.maxSize) {
            return this.fullSize;
        }
        int mipMap = this.maxSize / resolution;
        if (mipMap > this.mips.length) {
            mipMap = this.mips.length;
        }
        while (mipMap > 0) {
            CachedBufferBuilder buffer;
            if ((buffer = this.mips[--mipMap]) == null) continue;
            return buffer;
        }
        return this.fullSize;
    }

    public void putMips(CachedBufferBuilder buffer, int rects, int index) {
        if (this.mips[index] != null) {
            throw new IllegalStateException("Mip at index " + index + " already present");
        }
        if (this.sizes == null) {
            throw new IllegalStateException("Already complete!");
        }
        if (rects == -1) {
            this.mips[index] = index == 0 ? this.fullSize : this.mips[index - 1];
            this.sizes[index] = this.getRects(index - 1);
        } else {
            this.mips[index] = buffer;
            this.sizes[index] = rects;
        }
    }

    private int getRects(int index) {
        if (index == -1) {
            return this.fullSizeRect;
        }
        int rects = this.sizes[index];
        if (rects == 0) {
            throw new RuntimeException("Index " + index + " does not have mip info");
        }
        return rects;
    }

    public void complete() {
        this.sizes = null;
        for (int i = 0; i < this.mips.length; ++i) {
            if (this.mips[i] != null) continue;
            this.mips[i] = this.fullSize;
        }
    }

    public boolean needDiscard(int rects, int mipIndex) {
        boolean result;
        boolean bl = result = rects == -1 || !MCPaintConfig.CLIENT.enableMipMaps || (double)(rects / this.getRects(mipIndex - 2)) > MCPaintConfig.CLIENT.maxMipSize;
        if (result) {
            MCPaint.LOGGER.debug("Discarding mip level {}, with {} rects", (Object)mipIndex, (Object)rects);
        }
        return result;
    }
}

