/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.render;

import ichttt.mods.mcpaint.MCPaintConfig;
import ichttt.mods.mcpaint.client.render.BufferManager;
import ichttt.mods.mcpaint.client.render.PictureRenderer;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;

public class TESRCanvas
extends TileEntityRenderer<TileEntityCanvas> {
    private static final EnumFacing[] VALUES = EnumFacing.values();
    private static final WorldVertexBufferUploader vboUploader = new WorldVertexBufferUploader();

    public void render(TileEntityCanvas te, double x, double y, double z, float partialTicks, int destroyStage) {
        if (destroyStage != -1) {
            return;
        }
        double playerDistSq = Minecraft.func_71410_x().field_71439_g.func_174818_b(te.func_174877_v());
        if (playerDistSq < (double)(MCPaintConfig.CLIENT.maxPaintRenderDistance * MCPaintConfig.CLIENT.maxPaintRenderDistance)) {
            int light = Objects.requireNonNull(te.func_145831_w()).func_175626_b(te.func_174877_v(), 0);
            for (EnumFacing facing : VALUES) {
                if (!te.hasPaintFor(facing)) continue;
                TESRCanvas.renderFace(x, y, z, te, facing, light, playerDistSq);
            }
        } else {
            te.unbindBuffers();
        }
    }

    private static void renderFace(double x, double y, double z, TileEntityCanvas te, EnumFacing facing, int light, double playerDistSq) {
        boolean slow;
        boolean xOffset = false;
        boolean yOffset = false;
        boolean zOffset = false;
        int angle = 0;
        double translationXOffset = 0.0;
        double translationYOffset = 0.0;
        double translationZOffset = 0.0;
        switch (facing) {
            case NORTH: {
                angle = 0;
                zOffset = true;
                translationZOffset = 0.0015;
                break;
            }
            case EAST: {
                angle = 270;
                translationXOffset = -0.0015;
                break;
            }
            case SOUTH: {
                angle = 180;
                xOffset = true;
                translationZOffset = -0.0015;
                break;
            }
            case WEST: {
                angle = 90;
                xOffset = true;
                zOffset = true;
                translationXOffset = 0.0015;
                break;
            }
            case UP: {
                xOffset = true;
                zOffset = true;
                translationYOffset = -0.0015;
                break;
            }
            case DOWN: {
                yOffset = true;
                zOffset = true;
                translationYOffset = 0.0015;
            }
        }
        if (playerDistSq < 16.0) {
            translationXOffset /= 2.0;
            translationYOffset /= 2.0;
            translationZOffset /= 2.0;
        }
        if (playerDistSq < 36.0) {
            translationXOffset /= 4.0;
            translationYOffset /= 4.0;
            translationZOffset /= 4.0;
        }
        if (playerDistSq < 64.0) {
            translationXOffset /= 2.0;
            translationYOffset /= 2.0;
            translationZOffset /= 2.0;
        }
        if (playerDistSq > 256.0) {
            translationXOffset *= 2.0;
            translationYOffset *= 2.0;
            translationZOffset *= 2.0;
        }
        if (playerDistSq > 1024.0) {
            translationXOffset *= 2.0;
            translationYOffset *= 2.0;
            translationZOffset *= 2.0;
        }
        if (playerDistSq > 4096.0) {
            translationXOffset *= 2.0;
            translationYOffset *= 2.0;
            translationZOffset *= 2.0;
        }
        if (playerDistSq > 9216.0) {
            translationXOffset *= 2.0;
            translationYOffset *= 2.0;
            translationZOffset *= 2.0;
        }
        PictureRenderer.setWorldGLState();
        GlStateManager.func_179137_b((double)(x + translationXOffset + (double)xOffset), (double)(y + translationYOffset + (double)yOffset), (double)(z + translationZOffset + (double)zOffset));
        int j = light % 65536;
        int k = light / 65536;
        if (k > MCPaintConfig.CLIENT.maxPaintBrightness) {
            k = MCPaintConfig.CLIENT.maxPaintBrightness;
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        if (angle != 0) {
            GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (facing.func_176740_k().func_200128_b()) {
            GlStateManager.func_179114_b((float)(facing == EnumFacing.DOWN ? -90.0f : 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(facing == EnumFacing.UP ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        IPaintable paint = te.getPaintFor(facing);
        boolean bl = slow = !MCPaintConfig.CLIENT.optimizePictures;
        if (!slow) {
            BufferManager builder = te.getBuffer(facing);
            if (builder == null) {
                if (playerDistSq < (double)((MCPaintConfig.CLIENT.maxPaintRenderDistance - 8) * (MCPaintConfig.CLIENT.maxPaintRenderDistance - 8))) {
                    slow = true;
                }
            } else {
                vboUploader.func_181679_a((BufferBuilder)builder.get(TESRCanvas.getRes(playerDistSq)));
            }
        }
        if (slow) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder builder = tessellator.func_178180_c();
            builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            PictureRenderer.renderInGame(paint.getScaleFactor(), builder, paint.getPictureData());
            tessellator.func_78381_a();
        }
        PictureRenderer.resetWorldGLState();
    }

    public static int getRes(double playerDistSq) {
        if (playerDistSq < 1024.0) {
            return 128;
        }
        if (playerDistSq < 4096.0) {
            return 64;
        }
        if (playerDistSq < 9216.0) {
            return 32;
        }
        if (playerDistSq < 16384.0) {
            return 16;
        }
        return 8;
    }
}

