/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.render.batch;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.MCPaintConfig;
import ichttt.mods.mcpaint.client.render.BufferManager;
import ichttt.mods.mcpaint.client.render.batch.IOptimisationCallback;
import ichttt.mods.mcpaint.client.render.batch.PictureOptimizationJob;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

public class RenderCache {
    private static final Cache<IPaintable, BufferManager> PAINT_CACHE = CacheBuilder.newBuilder().concurrencyLevel(2).expireAfterAccess(30L, TimeUnit.SECONDS).build();
    private static final ThreadPoolExecutor POOL_EXECUTOR = new ThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors() >= 8 ? 4 : 2, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
        private final AtomicInteger count = new AtomicInteger(1);

        @Override
        public Thread newThread(@Nonnull Runnable runnable) {
            Thread thread = new Thread(runnable, "MCPaint PictureOptimizer Thread-" + this.count.getAndIncrement());
            MCPaint.LOGGER.info("Starting " + thread.getName());
            thread.setDaemon(true);
            return thread;
        }
    });

    public static void getOrRequest(IPaintable paintable, IOptimisationCallback callback) {
        if (!MCPaintConfig.CLIENT.optimizePictures) {
            return;
        }
        BufferManager builder = RenderCache.getIfPresent(paintable);
        if (builder != null) {
            callback.provideFinishedBuffer(builder);
            return;
        }
        POOL_EXECUTOR.execute(new PictureOptimizationJob(paintable, callback));
    }

    public static BufferManager getIfPresent(IPaintable paintable) {
        return (BufferManager)PAINT_CACHE.getIfPresent((Object)paintable);
    }

    public static void cache(IPaintable paintable, BufferManager obj) {
        if (MCPaintConfig.CLIENT.optimizePictures) {
            PAINT_CACHE.put((Object)paintable, (Object)obj);
        }
    }

    public static void uncache(IPaintable paintable) {
        PAINT_CACHE.invalidate((Object)paintable);
    }

    public static void clear() {
        PAINT_CACHE.invalidateAll();
        PAINT_CACHE.cleanUp();
    }

    public static void scheduleCleanup() {
        if (MCPaintConfig.CLIENT.optimizePictures) {
            POOL_EXECUTOR.execute(() -> PAINT_CACHE.cleanUp());
        }
    }

    public static void onConfigReload() {
        POOL_EXECUTOR.allowCoreThreadTimeOut(!MCPaintConfig.CLIENT.optimizePictures);
        RenderCache.clear();
    }

    static {
        POOL_EXECUTOR.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            }
        });
    }
}

