/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common;

import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import ichttt.mods.mcpaint.networking.MessageClearSide;
import ichttt.mods.mcpaint.networking.MessagePaintData;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class MCPaintUtil {
    private static final Method getNetworkManager;

    public static boolean isPosInvalid(NetHandlerPlayServer handler, BlockPos pos) {
        if (!handler.field_147369_b.field_70170_p.func_175667_e(pos)) {
            MCPaint.LOGGER.warn("Player" + handler.field_147369_b.func_200200_C_() + " is trying to write to unloaded block");
            handler.func_194028_b((ITextComponent)new TextComponentString("Trying to write to unloaded block"));
            return true;
        }
        if (handler.field_147369_b.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > (double)(Math.round(handler.field_147369_b.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e()) + 5L)) {
            MCPaint.LOGGER.warn("Player" + handler.field_147369_b.func_200200_C_() + " is writing to out of reach block!");
            return true;
        }
        return false;
    }

    public static int[][] copyOf(int[][] array) {
        int[][] copy = new int[array.length][];
        for (int i = 0; i < array.length; ++i) {
            copy[i] = (int[])array[i].clone();
        }
        return copy;
    }

    public static boolean[][] copyOf(boolean[][] array) {
        boolean[][] copy = new boolean[array.length][];
        for (int i = 0; i < array.length; ++i) {
            copy[i] = (boolean[])array[i].clone();
        }
        return copy;
    }

    public static void uploadPictureToServer(@Nullable TileEntity te, EnumFacing facing, byte scaleFactor, int[][] picture, boolean clear) {
        if (!(te instanceof TileEntityCanvas)) {
            MCPaint.LOGGER.error("Could not set paint! Found block " + (te == null ? "NONE" : te.func_200662_C()));
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentString("Could not set paint!"), true);
            return;
        }
        TileEntityCanvas canvas = (TileEntityCanvas)te;
        if (clear) {
            MCPaint.NETWORKING.sendToServer((Object)new MessageClearSide(te.func_174877_v(), facing));
            canvas.removePaint(facing);
        } else {
            MessagePaintData.createAndSend(te.func_174877_v(), facing, scaleFactor, picture, arg_0 -> ((SimpleChannel)MCPaint.NETWORKING).sendToServer(arg_0));
            IPaintable paintable = canvas.getPaintFor(facing);
            paintable.setData(scaleFactor, picture, canvas, facing);
        }
    }

    public static <T extends INetHandler> T getNetHandler(NetworkEvent.Context context) {
        try {
            return (T)((NetworkManager)getNetworkManager.invoke((Object)context, new Object[0])).func_150729_e();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Method m;
        ReflectiveOperationException ex = null;
        try {
            m = NetworkEvent.Context.class.getDeclaredMethod("getNetworkManager", new Class[0]);
            m.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            m = null;
            ex = e;
        }
        getNetworkManager = m;
        if (ex != null) {
            throw new RuntimeException(ex);
        }
    }
}

