/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.block;

import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockCanvas
extends Block {
    public static final BooleanProperty IS_FULL_BLOCK = BooleanProperty.func_177716_a((String)"full_block");
    public static final BooleanProperty IS_NORMAL_CUBE = BooleanProperty.func_177716_a((String)"normal_cube");

    public BlockCanvas(Material material, ResourceLocation regNam) {
        super(Block.Properties.func_200945_a((Material)material).func_200948_a(1.0f, 4.0f));
        this.setRegistryName(regNam);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)IS_FULL_BLOCK, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)IS_NORMAL_CUBE, (Comparable)Boolean.valueOf(true)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(IBlockState state, IBlockReader world) {
        return new TileEntityCanvas();
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public float func_176195_g(IBlockState blockState, IBlockReader world, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_185887_b(world, pos);
        }
        return super.func_176195_g(blockState, world, pos);
    }

    public float getExplosionResistance(IBlockState state, IWorldReader world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_177230_c().getExplosionResistance(canvas.getContainedState(), world, pos, exploder, explosion);
        }
        return super.getExplosionResistance(state, world, pos, exploder, explosion);
    }

    public SoundType getSoundType(IBlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_177230_c().getSoundType(canvas.getContainedState(), world, pos, entity);
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (te instanceof TileEntityCanvas && ((TileEntityCanvas)te).getContainedState() != null) {
            TileEntityCanvas canvas = (TileEntityCanvas)te;
            state = canvas.getContainedState();
            state.func_177230_c().func_180657_a(world, player, pos, state, te, stack);
            return;
        }
        super.func_180657_a(world, player, pos, state, te, stack);
    }

    public boolean canHarvestBlock(IBlockState state, IBlockReader world, BlockPos pos, EntityPlayer player) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            state = canvas.getContainedState();
            return state.func_177230_c().canHarvestBlock(state, world, pos, player);
        }
        return super.canHarvestBlock(state, world, pos, player);
    }

    public VoxelShape func_196268_f(IBlockState state, IBlockReader world, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_196952_d(world, pos);
        }
        return super.func_196268_f(state, world, pos);
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader world, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_196954_c(world, pos);
        }
        return super.func_196244_b(state, world, pos);
    }

    public VoxelShape func_196247_c(IBlockState state, IBlockReader world, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_196951_e(world, pos);
        }
        return super.func_196247_c(state, world, pos);
    }

    public VoxelShape func_199600_g(IBlockState state, IBlockReader world, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_199611_f(world, pos);
        }
        return super.func_199600_g(state, world, pos);
    }

    public MaterialColor func_180659_g(IBlockState state, IBlockReader world, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_185909_g(world, pos);
        }
        return super.func_180659_g(state, world, pos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{IS_FULL_BLOCK, IS_NORMAL_CUBE});
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockReader world, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState();
        }
        return state;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull IBlockReader world, @Nonnull BlockPos pos, EntityPlayer player) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            state = canvas.getContainedState();
            return state.func_177230_c().getPickBlock(canvas.getContainedState(), target, world, pos, player);
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_149686_d(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)IS_FULL_BLOCK);
    }

    public boolean func_149721_r(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)IS_NORMAL_CUBE);
    }

    public boolean func_149637_q(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)IS_FULL_BLOCK);
    }

    public IBlockState getStateFrom(IBlockState state) {
        return (IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)IS_NORMAL_CUBE, (Comparable)Boolean.valueOf(state.func_185915_l()))).func_206870_a((IProperty)IS_FULL_BLOCK, (Comparable)Boolean.valueOf(state.func_185898_k()));
    }
}

