/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.item;

import ichttt.mods.mcpaint.client.ClientHooks;
import ichttt.mods.mcpaint.client.render.TEISRStamp;
import ichttt.mods.mcpaint.common.EventHandler;
import ichttt.mods.mcpaint.common.block.BlockCanvas;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class ItemBrush
extends Item {
    public static Item.Properties getProperties() {
        Item.Properties properties = new Item.Properties();
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> properties.setTEISR(TEISRStamp::getInstance));
        properties.func_200916_a(ItemGroup.field_78031_c).func_200917_a(1).func_200915_b(32);
        return properties;
    }

    public ItemBrush(ResourceLocation registryName) {
        super(ItemBrush.getProperties());
        this.setRegistryName(registryName);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        RayTraceResult raytraceresult = this.func_77621_a(world, player, false);
        if (raytraceresult == null || raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(this.processMiss(world, player, hand, held, raytraceresult), (Object)held);
        }
        BlockPos pos = raytraceresult.func_178782_a();
        IBlockState state = world.func_180495_p(pos);
        EnumFacing facing = raytraceresult.field_178784_b;
        return new ActionResult(this.processHit(world, player, held, pos, state, facing), (Object)held);
    }

    protected EnumActionResult processMiss(World world, EntityPlayer player, EnumHand hand, ItemStack stack, @Nullable RayTraceResult result) {
        return EnumActionResult.FAIL;
    }

    protected EnumActionResult processHit(World world, EntityPlayer player, ItemStack held, BlockPos pos, IBlockState state, EnumFacing facing) {
        if (state.func_177230_c() instanceof BlockCanvas) {
            TileEntityCanvas canvas = (TileEntityCanvas)Objects.requireNonNull(world.func_175625_s(pos));
            if (canvas.isSideBlockedForPaint(facing)) {
                return EnumActionResult.FAIL;
            }
            this.startPainting(canvas, world, held, pos, facing.func_176734_d(), state);
            held.func_77972_a(1, (EntityLivingBase)player);
            return EnumActionResult.SUCCESS;
        }
        if (state.func_193401_d((IBlockReader)world, pos, facing) == BlockFaceShape.SOLID && state.func_185904_a().func_76218_k() && state.func_185917_h() == state.func_185898_k() && state.func_185901_i() == EnumBlockRenderType.MODEL && !state.func_177230_c().hasTileEntity(state)) {
            EnumSet<EnumFacing> disallowedFaces = EnumSet.noneOf(EnumFacing.class);
            for (EnumFacing testFacing : EnumFacing.values()) {
                if (state.func_193401_d((IBlockReader)world, pos, testFacing) == BlockFaceShape.SOLID) continue;
                disallowedFaces.add(testFacing);
            }
            if (state.func_185904_a().func_76217_h()) {
                world.func_175656_a(pos, EventHandler.CANVAS_WOOD.getStateFrom(state));
            } else if (state.func_185904_a().func_76229_l()) {
                world.func_175656_a(pos, EventHandler.CANVAS_GROUND.getStateFrom(state));
            } else {
                world.func_175656_a(pos, EventHandler.CANVAS_ROCK.getStateFrom(state));
            }
            TileEntityCanvas canvas = (TileEntityCanvas)Objects.requireNonNull(world.func_175625_s(pos));
            canvas.setInitialData(state, disallowedFaces);
            canvas.func_70296_d();
            this.startPainting(canvas, world, held, pos, facing.func_176734_d(), state);
            held.func_77972_a(1, (EntityLivingBase)player);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    protected void startPainting(TileEntityCanvas canvas, World world, ItemStack heldItem, BlockPos pos, EnumFacing facing, IBlockState state) {
        if (world.field_72995_K) {
            if (canvas.hasPaintFor(facing)) {
                ArrayList<IPaintable> list = new ArrayList<IPaintable>(1);
                list.add(canvas.getPaintFor(facing));
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHooks.showGuiDraw(list, canvas.func_174877_v(), facing, canvas.getContainedState()));
            } else {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHooks.showGuiDraw(pos, facing, canvas.getContainedState()));
            }
        }
    }
}

