/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.BufferBuilder;

public class PictureRenderer {
    public static void renderInGui(double leftOffset, double topOffset, byte scaleFactor, BufferBuilder builder, int[][] picture) {
        for (int x = 0; x < picture.length; ++x) {
            int[] yPos = picture[x];
            for (int y = 0; y < yPos.length; ++y) {
                int color = picture[x][y];
                double left = leftOffset + (double)(x * scaleFactor);
                double top = topOffset + (double)(y * scaleFactor);
                double right = left + (double)scaleFactor;
                double bottom = top + (double)scaleFactor;
                PictureRenderer.drawToBuffer(color, builder, left, top, right, bottom);
            }
        }
    }

    public static void renderInGame(byte scaleFactor, BufferBuilder builder, int[][] picture) {
        for (int x = 0; x < picture.length; ++x) {
            int[] yPos = picture[x];
            for (int y = 0; y < yPos.length; ++y) {
                int color = picture[x][y];
                double left = (float)(x * scaleFactor) / 128.0f + (float)scaleFactor / 128.0f;
                double top = 1.0f - (float)(y * scaleFactor) / 128.0f - (float)scaleFactor / 128.0f;
                double right = left - (double)((float)scaleFactor / 128.0f);
                double bottom = top + (double)((float)scaleFactor / 128.0f);
                PictureRenderer.drawToBuffer(color, builder, left, top, right, bottom);
            }
        }
    }

    public static void setWorldGLState() {
        GlStateManager.pushMatrix();
        GlStateManager.enableDepthTest();
        GlStateManager.disableTexture();
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void resetWorldGLState() {
        GlStateManager.disableBlend();
        GlStateManager.enableTexture();
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
    }

    public static boolean drawToBuffer(int color, BufferBuilder builder, double left, double top, double right, double bottom) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        if (a <= 0.01f) {
            return true;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        builder.func_181662_b(left, bottom, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        builder.func_181662_b(right, bottom, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        builder.func_181662_b(right, top, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        builder.func_181662_b(left, top, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        return false;
    }
}

