/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.render;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import ichttt.mods.mcpaint.MCPaintConfig;
import ichttt.mods.mcpaint.client.render.BufferManager;
import ichttt.mods.mcpaint.client.render.PictureRenderer;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class TESRCanvas
extends TileEntityRenderer<TileEntityCanvas> {
    private static final Direction[] VALUES = Direction.values();
    private static final WorldVertexBufferUploader vboUploader = new WorldVertexBufferUploader();

    public void render(TileEntityCanvas te, double x, double y, double z, float partialTicks, int destroyStage) {
        int maxDist;
        if (destroyStage != -1) {
            return;
        }
        BlockPos pos = te.func_174877_v();
        double playerDistSq = Minecraft.func_71410_x().field_71439_g.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        if (playerDistSq < (double)((maxDist = ((Integer)MCPaintConfig.CLIENT.maxPaintRenderDistance.get()).intValue()) * maxDist)) {
            int light = Objects.requireNonNull(te.func_145831_w()).func_217338_b(te.func_174877_v(), 0);
            for (Direction facing : VALUES) {
                if (!te.hasPaintFor(facing)) continue;
                TESRCanvas.renderFace(x, y, z, te, facing, light, playerDistSq);
            }
        } else {
            te.unbindBuffers();
        }
    }

    private static void renderFace(double x, double y, double z, TileEntityCanvas te, Direction facing, int light, double playerDistSq) {
        boolean slow;
        boolean xOffset = false;
        boolean yOffset = false;
        boolean zOffset = false;
        int angle = 0;
        double translationXOffset = 0.0;
        double translationYOffset = 0.0;
        double translationZOffset = 0.0;
        switch (facing) {
            case NORTH: {
                angle = 0;
                zOffset = true;
                translationZOffset = 0.0015;
                break;
            }
            case EAST: {
                angle = 270;
                translationXOffset = -0.0015;
                break;
            }
            case SOUTH: {
                angle = 180;
                xOffset = true;
                translationZOffset = -0.0015;
                break;
            }
            case WEST: {
                angle = 90;
                xOffset = true;
                zOffset = true;
                translationXOffset = 0.0015;
                break;
            }
            case UP: {
                xOffset = true;
                zOffset = true;
                translationYOffset = -0.0015;
                break;
            }
            case DOWN: {
                yOffset = true;
                zOffset = true;
                translationYOffset = 0.0015;
            }
        }
        if (playerDistSq < 16.0) {
            translationXOffset /= 2.0;
            translationYOffset /= 2.0;
            translationZOffset /= 2.0;
        }
        if (playerDistSq < 36.0) {
            translationXOffset /= 4.0;
            translationYOffset /= 4.0;
            translationZOffset /= 4.0;
        }
        if (playerDistSq < 64.0) {
            translationXOffset /= 2.0;
            translationYOffset /= 2.0;
            translationZOffset /= 2.0;
        }
        if (playerDistSq > 256.0) {
            translationXOffset *= 2.0;
            translationYOffset *= 2.0;
            translationZOffset *= 2.0;
        }
        if (playerDistSq > 1024.0) {
            translationXOffset *= 2.0;
            translationYOffset *= 2.0;
            translationZOffset *= 2.0;
        }
        if (playerDistSq > 4096.0) {
            translationXOffset *= 2.0;
            translationYOffset *= 2.0;
            translationZOffset *= 2.0;
        }
        if (playerDistSq > 9216.0) {
            translationXOffset *= 2.0;
            translationYOffset *= 2.0;
            translationZOffset *= 2.0;
        }
        PictureRenderer.setWorldGLState();
        GlStateManager.translated((double)(x + translationXOffset + (double)xOffset), (double)(y + translationYOffset + (double)yOffset), (double)(z + translationZOffset + (double)zOffset));
        int j = light % 65536;
        int k = light / 65536;
        int maxBrightness = (Integer)MCPaintConfig.CLIENT.maxPaintBrightness.get();
        if (k > maxBrightness) {
            k = maxBrightness;
        }
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)0.0f, (float)maxBrightness);
        if (angle != 0) {
            GlStateManager.rotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (facing.func_176740_k().func_200128_b()) {
            GlStateManager.rotatef((float)(facing == Direction.DOWN ? -90.0f : 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)(facing == Direction.UP ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        IPaintable paint = te.getPaintFor(facing);
        boolean bl = slow = (Boolean)MCPaintConfig.CLIENT.optimizePictures.get() == false;
        if (!slow) {
            BufferManager builder = te.getBuffer(facing);
            if (builder == null) {
                int maxDistOffset = (Integer)MCPaintConfig.CLIENT.maxPaintRenderDistance.get() - 8;
                if (playerDistSq < (double)(maxDistOffset * maxDistOffset)) {
                    slow = true;
                }
            } else {
                vboUploader.func_181679_a((BufferBuilder)builder.get(TESRCanvas.getRes(playerDistSq)));
            }
        }
        if (slow) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder builder = tessellator.func_178180_c();
            builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            PictureRenderer.renderInGame(paint.getScaleFactor(), builder, paint.getPictureData());
            tessellator.func_78381_a();
        }
        PictureRenderer.resetWorldGLState();
    }

    public static int getRes(double playerDistSq) {
        if (playerDistSq < 1024.0) {
            return 128;
        }
        if (playerDistSq < 4096.0) {
            return 64;
        }
        if (playerDistSq < 9216.0) {
            return 32;
        }
        if (playerDistSq < 16384.0) {
            return 16;
        }
        return 8;
    }
}

