/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.render.batch;

import ichttt.mods.mcpaint.MCPaintConfig;
import ichttt.mods.mcpaint.client.render.BufferManager;
import ichttt.mods.mcpaint.client.render.CachedBufferBuilder;
import ichttt.mods.mcpaint.client.render.TESRCanvas;
import ichttt.mods.mcpaint.client.render.batch.IOptimisationCallback;
import ichttt.mods.mcpaint.client.render.batch.LossyCompression;
import ichttt.mods.mcpaint.client.render.batch.PictureCacheBuilder;
import ichttt.mods.mcpaint.client.render.batch.RenderCache;
import ichttt.mods.mcpaint.common.MCPaintUtil;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import org.apache.commons.lang3.tuple.Pair;

public class PictureOptimizationJob
implements Runnable {
    private final IPaintable paintable;
    private final IOptimisationCallback callback;

    public PictureOptimizationJob(IPaintable paintable, IOptimisationCallback callback) {
        this.paintable = paintable;
        this.callback = callback;
    }

    @Override
    public void run() {
        byte scaleFactor;
        if (this.callback.isInvalid()) {
            return;
        }
        BufferManager cached = RenderCache.getIfPresent(this.paintable);
        if (cached != null) {
            this.callback.provideFinishedBuffer(cached);
            return;
        }
        int[][] pictureData = MCPaintUtil.copyOf(this.paintable.getPictureData());
        Pair<CachedBufferBuilder, Integer> pair = PictureCacheBuilder.batch(pictureData, scaleFactor = this.paintable.getScaleFactor(), this.callback, val -> false, 0, 0);
        if (pair == null) {
            return;
        }
        int maxMips = (Boolean)MCPaintConfig.CLIENT.enableMipMaps.get() != false ? PictureOptimizationJob.getMaxPass(pictureData.length) : 0;
        BufferManager manager = new BufferManager((CachedBufferBuilder)((Object)pair.getLeft()), (Integer)pair.getRight(), maxMips, pictureData.length);
        this.callback.provideFinishedBuffer(manager);
        if (maxMips > 0) {
            for (int i = 1; i <= maxMips; ++i) {
                int currentMip;
                byte newScaleFactor;
                int[][] newPicture = LossyCompression.mipMap(pictureData, i);
                pair = PictureCacheBuilder.batch(newPicture, newScaleFactor = (byte)((double)scaleFactor * Math.pow(2.0, i)), this.callback, arg_0 -> PictureOptimizationJob.lambda$run$1(manager, currentMip = i, arg_0), (Integer)MCPaintConfig.CLIENT.maxTotalColorDiffPerMip.get() * i, (Integer)MCPaintConfig.CLIENT.maxSingleColorDiffPerMip.get() * i);
                if (pair != null) {
                    manager.putMips((CachedBufferBuilder)((Object)pair.getLeft()), (Integer)pair.getRight(), i - 1);
                    continue;
                }
                manager.putMips(null, -1, i - 1);
            }
        }
        manager.complete();
    }

    private static int getMaxPass(int res) {
        int maxDist = (Integer)MCPaintConfig.CLIENT.maxPaintRenderDistance.get();
        int lowestRes = TESRCanvas.getRes(maxDist * maxDist);
        int mips = 0;
        while (lowestRes < res) {
            lowestRes *= 2;
            ++mips;
        }
        return mips;
    }

    private static /* synthetic */ Boolean lambda$run$1(BufferManager manager, int currentMip, Integer val) {
        return manager.needDiscard(val, currentMip);
    }
}

